/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.controls.etatFrais.chorus;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M052
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(M052.class);
    public static final String CTRL_ID = "CTL-M052";
    private Hashtable<String, Object> hParams;
    Vector<Anomalie> anomalies = null;
    private Stack<StringBuffer> chars = new Stack();
    private String value_NodeId = "";
    private int compteur_erreur = 0;
    private String STRING_TO_COMPARE = "CH_NATURE_MINISTERIELLE";
    private String ID_Invoice = "";
    private String ID_InvoiceLine = "";
    private boolean is_contralable = false;
    private String ID_Invoice_Unique = "";
    private static final String MSG_IDLINE = "#IDLINE#";
    private static final String MSG_IDInvoice = "#ID_Invoice#";
    private static final String MSG_ERREUR = "#ERREUR#";
    public static final transient String RESET_COUNTER_PATH = "EtatsFrais/Invoice/";
    public static final transient String REQUIRED_PATH = "EtatsFrais/Invoice/InvoiceLine/Item/AdditionalItemProperty/Name/";
    public static final transient String VALUE_PATH = "EtatsFrais/Invoice/InvoiceLine/Item/AdditionalItemProperty/Value/";
    public static final transient String InvoiceLine_ID = "EtatsFrais/Invoice/InvoiceLine/ID/";
    public static final transient String RETURN_ANOMALIES_PATH = "EtatsFrais/Invoice/";
    public static final transient String ID_Invoice_PATH = "EtatsFrais/Invoice/ID/";
    public static final transient String AdditionalItemProperty_PATH = "EtatsFrais/Invoice/InvoiceLine/Item/AdditionalItemProperty/";

    public void endDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) throws SAXException {
        if (xpath.equals(VALUE_PATH)) {
            this.value_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.equals(AdditionalItemProperty_PATH)) {
            this.is_contralable = false;
            this.value_NodeId = "";
            this.compteur_erreur = 0;
        }
        if (xpath.equals("EtatsFrais/Invoice/")) {
            this.anomalies = new Vector();
            this.ID_Invoice = "";
            this.ID_Invoice_Unique = atts.getValue("ano:unique-id");
        }
        this.chars.push(new StringBuffer());
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        String erreur = "";
        if (xpath.equals(REQUIRED_PATH) && this.chars.peek().toString().equals(this.STRING_TO_COMPARE)) {
            this.is_contralable = true;
        }
        if (xpath.equals(VALUE_PATH) && this.is_contralable && this.chars.peek().toString().length() > 11) {
            ++this.compteur_erreur;
        }
        if (xpath.equals(InvoiceLine_ID)) {
            this.ID_InvoiceLine = this.chars.peek().toString();
        }
        if (xpath.equals(ID_Invoice_PATH)) {
            this.ID_Invoice = this.chars.peek().toString();
        }
        if (xpath.equals(AdditionalItemProperty_PATH) && this.compteur_erreur != 0) {
            erreur = "Longueur de AdditionalItemProperty/Value associee a CH_NATURE_MINISTERIELLE incorrecte";
            String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
            msg = msg.replaceAll(MSG_IDLINE, String.valueOf(this.ID_InvoiceLine));
            msg = msg.replaceAll(MSG_IDInvoice, this.ID_Invoice);
            msg = msg.replaceAll(MSG_ERREUR, erreur);
            String path = "@ano:unique-id='" + this.ID_Invoice_Unique + "'";
            String anoId = IdGenerator.nextId();
            String libelleLien = "Invoice " + this.ID_Invoice;
            Hashtable<String, String> xslParams = new Hashtable<String, String>();
            xslParams.put("anoId", anoId);
            xslParams.put("presentation", "src");
            Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID), this.getDocumentModel().getDocumentId(), "EtatFrais", "invoice", this.ID_Invoice, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
            ano.addNode(new Node(this.value_NodeId));
            this.anomalies.add(ano);
            this.chars.pop();
            return null;
        }
        if (xpath.equals("EtatsFrais/Invoice/")) {
            this.chars.pop();
            return this.anomalies;
        }
        this.chars.pop();
        return null;
    }

    private void Println(String partyIdentification) {
    }

    public void characters(char[] ch, int start, int length, String xpath) throws SAXException {
        this.chars.peek().append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) throws SAXException {
    }

    public void processingInstruction(String target, String data, String xpath) throws SAXException {
    }

    public void skippedEntity(String name, String xpath) throws SAXException {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        logger.info((Object)"In CTL-M052");
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) throws SAXException {
    }

    public void endPrefixMapping(String prefix, String xpath) throws SAXException {
    }
}

