/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.entreesdirectesstock;

import fr.gouv.finances.cp.utils.StringUtilities;
import fr.gouv.finances.cp.utils.xml.marshal.MutableBoolean;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.txt2xml.AbstractTxt2Xml;
import fr.gouv.finances.dgfip.xemelios.txt2xml.Txt2Xml;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class EntreesDirectesStockTxt2Xml
extends AbstractTxt2Xml
implements Txt2Xml {
    private static final Logger logger = Logger.getLogger(EntreesDirectesStockTxt2Xml.class);
    private static final String ENCODING_TXT = "UTF-8";
    private static final String ENCODING_XML = "ISO-8859-15";
    private static final int LENGTH_ENTETE = 360;
    private static final int LENGTH_LINE = 703;
    private static final String TAG_FEN = "FEN0070A";
    private static final String TAG_ETAT = "EDS";
    private static final String TAG_ENTETE = "ENTETE";
    private static final String TAG_LIGNE = "POSTE";
    private static final String TAG_LIGNE_INCONNUE = "LIGNE_INCONNUE";
    private static final String NAMESPACE = "FEN0070A";
    private MutableBoolean premierEntete = new MutableBoolean(true);

    public File transform(File f) {
        File ret = null;
        try {
            ret = FileUtils.isXmlFile((File)f, (String)ENCODING_TXT) ? f : this.makeTransformEntreesDirectesStock(f);
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me de transformation du flux !", (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File makeTransformEntreesDirectesStock(File f) throws IOException {
        File outputFile = new File(FileUtils.getTempDir(), f.getName());
        outputFile.createNewFile();
        Connection con = PoolManager.getInstance().getConnection();
        this.createDataBaseDonnees(con);
        this.insertionDonneesPourTri(f, con);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            fos.write("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>\n<FEN0070A xmlns=\"FEN0070A\" xmlns:txt2xml=\"http://www.xemelios.org/namespaces#txt2xml\">\n".getBytes(ENCODING_XML));
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT FEN_DONNEES,FEN_NUM_LIGNE FROM FEN_DONNEES_TRI ORDER BY FEN_CLE ASC");
            while (rs.next()) {
                String donnees = rs.getString(1);
                int nbLignesParcourues = Integer.parseInt(rs.getString(2));
                if (donnees.trim().length() <= 0) continue;
                if (donnees.substring(0, 1).equals("E")) {
                    fos.write(this.makeTranformEntete(donnees, nbLignesParcourues));
                    continue;
                }
                if (donnees.substring(0, 1).equals("L")) {
                    fos.write(this.makeTranformLine(donnees, nbLignesParcourues));
                    continue;
                }
                if (donnees.substring(0, 1).equals("L") || donnees.substring(0, 1).equals("E")) continue;
                fos.write(this.makeTranformLineInconnue(donnees, nbLignesParcourues));
            }
            fos.write("\t</EDS>\n</FEN0070A>".getBytes(ENCODING_XML));
            fos.flush();
        }
        catch (UnsupportedEncodingException uee) {
            logger.debug((Object)"Probl\u00e8me d'\u00e9criture avec encoding !");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            PoolManager.getInstance().releaseConnection(con);
        }
        logger.info((Object)("Le fichier de sortie de transformation se trouve ici : " + outputFile.getAbsolutePath()));
        return outputFile;
    }

    private byte[] makeTranformEntete(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        StringBuffer sb = null;
        if (!this.premierEntete.booleanValue()) {
            sb = new StringBuffer("\t</EDS>\n\t<EDS>\n\t\t<ENTETE txt2xml:LineTxt=\"" + nbLignesParcourues + "\">\n");
        } else {
            this.premierEntete.setValue(false);
            sb = new StringBuffer("\t<EDS>\n\t\t<ENTETE txt2xml:LineTxt=\"" + nbLignesParcourues + "\">\n");
        }
        if (line.length() >= 359) {
            try {
                String codeAppli = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(1, 7));
                String idAe = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(7, 23));
                String dateCpt = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(23, 31));
                String datePhy = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(31, 39));
                String billOfLading = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(39, 55));
                String codeMvt = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(55, 58));
                String motifMvt = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(58, 62));
                String grGiSlipNo = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(62, 72));
                String prUname = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(72, 84));
                String txtEntete = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(84, 109));
                sb.append("\t\t\t<CODE_APPLI txt2xml:TxtValue=\"").append(codeAppli).append("\">").append(codeAppli.trim()).append("</CODE_APPLI>\n");
                sb.append("\t\t\t<ID_AE txt2xml:TxtValue=\"").append(idAe).append("\">").append(idAe.trim()).append("</ID_AE>\n");
                sb.append("\t\t\t<DATE_CPT txt2xml:TxtValue=\"").append(dateCpt).append("\">").append(dateCpt.trim()).append("</DATE_CPT>\n");
                sb.append("\t\t\t<DATE_PHY txt2xml:TxtValue=\"").append(datePhy).append("\">").append(datePhy.trim()).append("</DATE_PHY>\n");
                if (billOfLading.trim().length() > 0) {
                    sb.append("\t\t\t<BILL_OF_LADING txt2xml:TxtValue=\"").append(billOfLading).append("\">").append(billOfLading.trim()).append("</BILL_OF_LADING>\n");
                }
                sb.append("\t\t\t<CODE_MVT txt2xml:TxtValue=\"").append(codeMvt).append("\">").append(codeMvt.trim()).append("</CODE_MVT>\n");
                if (motifMvt.trim().length() > 0) {
                    sb.append("\t\t\t<MOTIF_MVT txt2xml:TxtValue=\"").append(motifMvt).append("\">").append(motifMvt.trim()).append("</MOTIF_MVT>\n");
                }
                if (grGiSlipNo.trim().length() > 0) {
                    sb.append("\t\t\t<GR_GI_SLIP_NO txt2xml:TxtValue=\"").append(grGiSlipNo).append("\">").append(grGiSlipNo.trim()).append("</GR_GI_SLIP_NO>\n");
                }
                sb.append("\t\t\t<PR_UNAME txt2xml:TxtValue=\"").append(prUname).append("\">").append(prUname.trim()).append("</PR_UNAME>\n");
                sb.append("\t\t\t<TXT_ENTETE txt2xml:TxtValue=\"").append(txtEntete).append("\">").append(txtEntete.trim()).append("</TXT_ENTETE>\n");
            }
            catch (Exception e) {
                System.out.println("ENTETE : Erreur de transfmormation : " + line);
            }
        } else {
            logger.debug((Object)("Longueur de " + line.length() + " : " + 358 + " <= " + line.length() + " <= " + 360));
        }
        sb.append("\t\t</ENTETE>\n");
        return sb.toString().getBytes(ENCODING_XML);
    }

    private byte[] makeTranformLine(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("\t\t<POSTE txt2xml:LineTxt=\"" + nbLignesParcourues + "\">\n");
        if (line.length() >= 702) {
            String idAe = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(1, 17));
            String IdLing = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(17, 23));
            String typeIdFonc = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(23, 53));
            String idFoncProd = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(53, 83));
            String idChorusProd = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(83, 101));
            String plant = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(101, 105));
            String stgeLoc = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(105, 109));
            String idFoncPartner = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(109, 189));
            String GRcomptespartner = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(189, 193));
            String idChourusPartner = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(193, 203));
            String quantity = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(203, 218));
            String unit = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(218, 221));
            String val = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(221, 246));
            String poNumber = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(246, 256));
            String poItem = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(256, 261));
            String txtPst = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(261, 311));
            String recept = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(311, 323));
            String webElem = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(323, 347));
            String idFoncSuppl = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(347, 427));
            String grcomptessuppl = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(427, 431));
            String idChourusSuppl = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(431, 441));
            String funcArea = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(441, 457));
            String anaMin = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(457, 479));
            String locMin = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(479, 501));
            String natMin = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(501, 512));
            String axmin1 = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(512, 534));
            String axmin2 = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(534, 556));
            sb.append("\t\t\t<ID_AE txt2xml:TxtValue=\"").append(idAe).append("\">").append(idAe.trim()).append("</ID_AE>\n");
            sb.append("\t\t\t<ID_LIG txt2xml:TxtValue=\"").append(IdLing).append("\">").append(IdLing.trim()).append("</ID_LIG>\n");
            if (typeIdFonc.trim().length() > 0) {
                sb.append("\t\t\t<TYPE_ID_FONC txt2xml:TxtValue=\"").append(typeIdFonc).append("\">").append(typeIdFonc.trim()).append("</TYPE_ID_FONC>\n");
            }
            if (idFoncProd.trim().length() > 0) {
                sb.append("\t\t\t<ID_FONC_PROD txt2xml:TxtValue=\"").append(idFoncProd).append("\">").append(idFoncProd.trim()).append("</ID_FONC_PROD>\n");
            }
            if (idChorusProd.trim().length() > 0) {
                sb.append("\t\t\t<ID_CHORUS_PROD txt2xml:TxtValue=\"").append(idChorusProd).append("\">").append(idChorusProd.trim()).append("</ID_CHORUS_PROD>\n");
            }
            sb.append("\t\t\t<PLANT txt2xml:TxtValue=\"").append(plant).append("\">").append(plant.trim()).append("</PLANT>\n");
            sb.append("\t\t\t<STGE_LOC txt2xml:TxtValue=\"").append(stgeLoc).append("\">").append(stgeLoc.trim()).append("</STGE_LOC>\n");
            if (idFoncPartner.trim().length() > 0) {
                sb.append("\t\t\t<ID_FONC_PARTNER txt2xml:TxtValue=\"").append(idFoncPartner).append("\">").append(idFoncPartner.trim()).append("</ID_FONC_PARTNER>\n");
            }
            if (GRcomptespartner.trim().length() > 0) {
                sb.append("\t\t\t<GR_COMPTES_PARTNER txt2xml:TxtValue=\"").append(GRcomptespartner).append("\">").append(GRcomptespartner.trim()).append("</GR_COMPTES_PARTNER>\n");
            }
            if (idChourusPartner.trim().length() > 0) {
                sb.append("\t\t\t<ID_CHORUS_PARTNER txt2xml:TxtValue=\"").append(idChourusPartner).append("\">").append(idChourusPartner.trim()).append("</ID_CHORUS_PARTNER>\n");
            }
            sb.append("\t\t\t<QUANTITY txt2xml:TxtValue=\"").append(quantity).append("\">").append(quantity.trim()).append("</QUANTITY>\n");
            if (unit.trim().length() > 0) {
                sb.append("\t\t\t<UNIT txt2xml:TxtValue=\"").append(unit).append("\">").append(unit.trim()).append("</UNIT>\n");
            }
            if (val.trim().length() > 0) {
                sb.append("\t\t\t<VAL txt2xml:TxtValue=\"").append(val).append("\">").append(val.trim()).append("</VAL>\n");
            }
            if (poNumber.trim().length() > 0) {
                sb.append("\t\t\t<PO_NUMBER txt2xml:TxtValue=\"").append(poNumber).append("\">").append(poNumber.trim()).append("</PO_NUMBER>\n");
            }
            if (poItem.trim().length() > 0) {
                sb.append("\t\t\t<PO_ITEM txt2xml:TxtValue=\"").append(poItem).append("\">").append(poItem.trim()).append("</PO_ITEM>\n");
            }
            if (txtPst.trim().length() > 0) {
                sb.append("\t\t\t<TXT_PST txt2xml:TxtValue=\"").append(txtPst).append("\">").append(txtPst.trim()).append("</TXT_PST>\n");
            }
            if (recept.trim().length() > 0) {
                sb.append("\t\t\t<RECEPT txt2xml:TxtValue=\"").append(recept).append("\">").append(recept.trim()).append("</RECEPT>\n");
            }
            if (webElem.trim().length() > 0) {
                sb.append("\t\t\t<WBS_ELEM txt2xml:TxtValue=\"").append(webElem).append("\">").append(webElem.trim()).append("</WBS_ELEM>\n");
            }
            if (idFoncSuppl.trim().length() > 0) {
                sb.append("\t\t\t<ID_FONC_SUPPL txt2xml:TxtValue=\"").append(idFoncSuppl).append("\">").append(idFoncSuppl.trim()).append("</ID_FONC_SUPPL>\n");
            }
            if (grcomptessuppl.trim().length() > 0) {
                sb.append("\t\t\t<GR_COMPTES_SUPPL txt2xml:TxtValue=\"").append(grcomptessuppl).append("\">").append(grcomptessuppl.trim()).append("</GR_COMPTES_SUPPL>\n");
            }
            if (idChourusSuppl.trim().length() > 0) {
                sb.append("\t\t\t<ID_CHOR_SUPPL txt2xml:TxtValue=\"").append(idChourusSuppl).append("\">").append(idChourusSuppl.trim()).append("</ID_CHOR_SUPPL>\n");
            }
            if (funcArea.trim().length() > 0) {
                sb.append("\t\t\t<FUNC_AREA txt2xml:TxtValue=\"").append(funcArea).append("\">").append(funcArea.trim()).append("</FUNC_AREA>\n");
            }
            if (anaMin.trim().length() > 0) {
                sb.append("\t\t\t<ANA_MIN txt2xml:TxtValue=\"").append(anaMin).append("\">").append(anaMin.trim()).append("</ANA_MIN>\n");
            }
            if (locMin.trim().length() > 0) {
                sb.append("\t\t\t<LOC_MIN txt2xml:TxtValue=\"").append(locMin).append("\">").append(locMin.trim()).append("</LOC_MIN>\n");
            }
            if (natMin.trim().length() > 0) {
                sb.append("\t\t\t<NAT_MIN txt2xml:TxtValue=\"").append(natMin).append("\">").append(natMin.trim()).append("</NAT_MIN>\n");
            }
            if (axmin1.trim().length() > 0) {
                sb.append("\t\t\t<AXMIN1 txt2xml:TxtValue=\"").append(axmin1).append("\">").append(axmin1.trim()).append("</AXMIN1>\n");
            }
            if (axmin2.trim().length() > 0) {
                sb.append("\t\t\t<AXMIN2 txt2xml:TxtValue=\"").append(axmin2).append("\">").append(axmin2.trim()).append("</AXMIN2>\n");
            }
        }
        sb.append("\t\t</POSTE>\n");
        return sb.toString().getBytes(ENCODING_XML);
    }

    private byte[] makeTranformLineInconnue(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        System.out.println("makeTranformLine : " + line);
        StringBuffer sb = new StringBuffer("\t\t<LIGNE_INCONNUE txt2xml:LineTxt=\"" + nbLignesParcourues + "\">\n");
        if (line.trim().length() != 0) {
            sb.append("\t\t\t<LIGNE_INCONNUE txt2xml:TxtValue=\"").append(line).append("\">").append(line.trim()).append("</LIGNE_INCONNUE>\n");
        }
        sb.append("\t\t</LIGNE_INCONNUE>\n");
        return sb.toString().getBytes(ENCODING_XML);
    }
}

