/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.demandeachat;

import fr.gouv.finances.dgfip.utils.xml.SAXWriter;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.importers.DefaultImporter;
import fr.gouv.finances.dgfip.xemelios.utils.XmlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DemandeAchatImporter
extends DefaultImporter {
    private static final Logger logger = Logger.getLogger(DemandeAchatImporter.class);
    public static final String COLLECTIVITE_PATH = "/FEN0067A/DA/ENTETE/SIRET_CPD/";
    private static final String EXPECTED_ERROR = "EXPECTED_ERROR";
    private File outputTmpFile;

    public DemandeAchatImporter(XemeliosUser user) {
        super(user);
    }

    protected FileInfo importFile(File f) throws Exception {
        this.getImpSvcProvider().startLongWait();
        File newFile = this.wrapFile(f);
        return super.importFile(newFile);
    }

    public void done() {
        super.done();
        this.outputTmpFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File wrapFile(File f) {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setNamespaceAware(true);
        this.outputTmpFile = new File(this.getTmpDir(), f.getName());
        while (this.outputTmpFile.exists()) {
            if (this.outputTmpFile.equals(f)) {
                File tmpDir = this.outputTmpFile.getParentFile();
                tmpDir = new File(tmpDir, "TMP-DIR");
                tmpDir.mkdirs();
                this.outputTmpFile = new File(tmpDir, f.getName());
                continue;
            }
            this.outputTmpFile.delete();
        }
        OutputStream fos = null;
        try {
            SAXParser collParser = fact.newSAXParser();
            CollHandler handler = new CollHandler((NamespaceContext)this.getDocumentModel().getNamespaces());
            String collectivite = "";
            try {
                collParser.parse(f, (DefaultHandler)handler);
            }
            catch (SAXException saxEx) {
                if (EXPECTED_ERROR.equals(saxEx.getMessage())) {
                    collectivite = handler.getCollectivite();
                }
                throw saxEx;
            }
            fos = new FileOutputStream(this.outputTmpFile);
            String encoding = DemandeAchatImporter.getFileEncoding((File)f);
            String passedColl = collectivite;
            SAXWriter writer = new SAXWriter(fos, encoding){

                public void startDocument() throws SAXException {
                    super.startDocument();
                    this.startPrefixMapping("added", "http://projets.admisource.gouv.fr/xemelios/namespaces#added");
                    this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "DocDemandeAchat", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "DocDemandeAchat", "added").toString(), new AttributesImpl());
                    AttributesImpl attrsColl = new AttributesImpl();
                    attrsColl.addAttribute("", "code", "", "xs:string", "000000");
                    attrsColl.addAttribute("", "libelle", "", "xs:string", "ETAT");
                    this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", "added").toString(), attrsColl);
                    this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", "added").toString());
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addAttribute("", "code", "", "xs:string", "00");
                    attrs.addAttribute("", "libelle", "", "xs:string", "LFI");
                    this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", "added").toString(), attrs);
                    this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", "added").toString());
                }

                public void endDocument() throws SAXException {
                    this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "DocDemandeAchat", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "DocDemandeAchat", "added").toString());
                    this.endPrefixMapping("added");
                    super.endDocument();
                }

                public void processingInstruction(String target, String data) throws SAXException {
                }
            };
            SAXParser parser = fact.newSAXParser();
            parser.parse(f, (DefaultHandler)writer);
        }
        catch (Exception ex) {
            logger.error((Object)"wrapFile(File):", (Throwable)ex);
        }
        finally {
            try {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
            catch (Throwable t) {}
        }
        return this.outputTmpFile;
    }

    private class CollHandler
    extends DefaultHandler {
        Stack<QName> stack;
        NamespaceContext nsCtx;
        Stack<StringBuffer> textContent;
        private String collectivite;

        public String getCollectivite() {
            return this.collectivite;
        }

        public CollHandler(NamespaceContext nsCtx) {
            this.nsCtx = nsCtx;
            this.stack = new Stack();
            this.textContent = new Stack();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            QName qname = XmlUtils.getQName((String)uri, (String)localName, (String)qName);
            this.stack.push(qname);
            this.textContent.push(new StringBuffer());
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            String pathTag = XmlUtils.getPath(this.stack, (NamespaceContext)this.nsCtx);
            if (DemandeAchatImporter.COLLECTIVITE_PATH.equals(pathTag)) {
                this.collectivite = this.textContent.peek().toString();
                throw new SAXException(DemandeAchatImporter.EXPECTED_ERROR);
            }
            this.stack.pop();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String s = new String(ch, start, length).trim();
            this.textContent.peek().append(s);
        }
    }
}

