/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.demandeachat;

import fr.gouv.finances.cp.utils.StringUtilities;
import fr.gouv.finances.cp.utils.xml.marshal.MutableBoolean;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.txt2xml.AbstractTxt2Xml;
import fr.gouv.finances.dgfip.xemelios.txt2xml.Txt2Xml;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DemandeAchatTxt2Xml
extends AbstractTxt2Xml
implements Txt2Xml {
    private static final Logger logger = Logger.getLogger(DemandeAchatTxt2Xml.class);
    private static final String ENCODING_TXT = "ISO-8859-15";
    private static final String ENCODING_XML = "ISO-8859-15";
    private static final int LENGTH_ANOMALIE_ENTETE = 335;
    private static final int LENGTH_ANOMALIE_LINE = 536;
    private static final int LENGTH_ANOMALIE_PARTENAIRE = 621;
    private static final int LENGTH_ANOMALIE_IMPUTATION = 592;
    private static final int LENGTH_ANOMALIE_TEXTE = 405;
    private static final int LENGTH_ENTETE = 85;
    private static final int LENGTH_LINE = 301;
    private static final int LENGTH_IMPUTATION = 342;
    private static final int LENGTH_PARTENAIRE = 371;
    private static final int LENGTH_TEXTE = 155;
    private static final String TAG_ETAT = "DA";
    private static final String TAG_LIGNE_INCONNUE = "LIGNE_INCONNUE";
    private static final String TAG_ENTETE = "ENTETE";
    private static final String TAG_LIGNE = "POSTE";
    private static final String TAG_PARTENAIRE = "PARTENAIRE";
    private static final String TAG_IMPUTATION = "IMPUTATION";
    private static final String TAG_TEXTE = "TEXTE";
    private static final String NAMESPACE = "FEN0067A";
    private MutableBoolean premierEntete = new MutableBoolean(true);

    public DemandeAchatTxt2Xml() {
        this.TAG_FEN = NAMESPACE;
    }

    public File transform(File f) {
        File ret = null;
        try {
            ret = FileUtils.isXmlFile((File)f, (String)"ISO-8859-15") ? f : this.makeTransformDA(f);
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me de transformation du flux !", (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File makeTransformDA(File f) throws IOException {
        File outputFile = new File(FileUtils.getTempDir(), f.getName());
        outputFile.createNewFile();
        Connection con = PoolManager.getInstance().getConnection();
        this.createDataBaseDonnees(con);
        this.insertionDonneesPourTri(f, con);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            fos.write(("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>\n<" + this.TAG_FEN + " xmlns=\"" + NAMESPACE + "\" xmlns:ano=\"" + MainWindow.getInstance().getDocModels().getDocumentById("DocDemandeAchat").getNamespaces().getNamespaceURI("ano") + "\" xmlns:txt2xml=\"http://www.xemelios.org/namespaces#txt2xml\">\n").getBytes("ISO-8859-15"));
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT FEN_DONNEES,FEN_NUM_LIGNE FROM FEN_DONNEES_TRI ORDER BY FEN_CLE ASC");
            while (rs.next()) {
                String donnees = rs.getString(1);
                int nbLignesParcourues = Integer.parseInt(rs.getString(2));
                if (donnees.trim().length() <= 0) continue;
                if (donnees.substring(0, 1).equals("E")) {
                    fos.write(this.makeTranformEntete(donnees, nbLignesParcourues));
                    continue;
                }
                if (donnees.substring(0, 1).equals("L")) {
                    fos.write(this.makeTranformLine(donnees, nbLignesParcourues));
                    continue;
                }
                if (donnees.substring(0, 1).equals("I")) {
                    fos.write(this.makeTranformImputation(donnees, nbLignesParcourues));
                    continue;
                }
                if (donnees.substring(0, 1).equals("T")) {
                    fos.write(this.makeTranformTexte(donnees, nbLignesParcourues));
                    continue;
                }
                if (donnees.substring(0, 1).equals("P")) {
                    fos.write(this.makeTranformPartenaire(donnees, nbLignesParcourues));
                    continue;
                }
                if (donnees.substring(0, 1).equals("L") || donnees.substring(0, 1).equals("E") || donnees.substring(0, 1).equals("I") || donnees.substring(0, 1).equals("T") || donnees.substring(0, 1).equals("P")) continue;
                fos.write(this.makeTranformLineInconnue(donnees, nbLignesParcourues));
            }
            fos.write(("\t</DA>\n</" + this.TAG_FEN + ">").getBytes("ISO-8859-15"));
            fos.flush();
        }
        catch (UnsupportedEncodingException uee) {
            logger.debug((Object)"Probl\u00e8me d'\u00e9criture avec encoding !");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            PoolManager.getInstance().releaseConnection(con);
        }
        logger.info((Object)("Le fichier de sortie de transformation se trouve ici : " + outputFile.getAbsolutePath()));
        return outputFile;
    }

    private byte[] makeTranformEntete(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        StringBuffer sb = null;
        if (!this.premierEntete.booleanValue()) {
            sb = new StringBuffer("\t</DA>\n\t<DA>\n\t\t<ENTETE txt2xml:LineTxt=\"" + nbLignesParcourues + "\"" + (line.length() < 334 ? " txt2xml:Length=\"" + line.length() + ";" + 334 + "\"" : "") + ">\n");
        } else {
            this.premierEntete.setValue(false);
            sb = new StringBuffer("\t<DA>\n\t\t<ENTETE txt2xml:LineTxt=\"" + nbLignesParcourues + "\"" + (line.length() < 334 ? " txt2xml:Length=\"" + line.length() + ";" + 334 + "\"" : "") + ">\n");
        }
        if (line.length() >= 84) {
            try {
                String idAe = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(1, 13));
                String codeAppli = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(13, 19));
                String description = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(19, 59));
                String docDate = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(59, 67));
                String initiateur = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(67, 79));
                String currency = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(79, 84));
                sb.append("\t\t\t<ID_AE txt2xml:TxtValue=\"").append(idAe).append("\">").append(idAe.trim()).append("</ID_AE>\n");
                sb.append("\t\t\t<CODE_APPLI txt2xml:TxtValue=\"").append(codeAppli).append("\">").append(codeAppli.trim()).append("</CODE_APPLI>\n");
                if (description.trim().length() > 0) {
                    sb.append("\t\t\t<DESCRIPTION txt2xml:TxtValue=\"").append(description).append("\">").append(description.trim()).append("</DESCRIPTION>\n");
                }
                sb.append("\t\t\t<DOC_DATE txt2xml:TxtValue=\"").append(docDate).append("\">").append(docDate.trim()).append("</DOC_DATE>\n");
                sb.append("\t\t\t<INITIATEUR txt2xml:TxtValue=\"").append(initiateur).append("\">").append(initiateur.trim()).append("</INITIATEUR>\n");
                if (currency.trim().length() > 0) {
                    sb.append("\t\t\t<CURRENCY txt2xml:TxtValue=\"").append(currency).append("\">").append(currency.trim()).append("</CURRENCY>\n");
                }
            }
            catch (Exception e) {
                System.out.println("ENTETE : Erreur de transfmormation : " + line);
            }
        } else {
            logger.debug((Object)("Pb makeTranformEntete()->length=" + line.length()));
        }
        sb.append("\t\t</ENTETE>\n");
        return sb.toString().getBytes("ISO-8859-15");
    }

    private byte[] makeTranformLine(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("\t\t<POSTE txt2xml:LineTxt=\"" + nbLignesParcourues + "\"" + (line.length() < 535 ? " txt2xml:Length=\"" + line.length() + ";" + 535 + "\"" : "") + ">\n");
        if (line.length() >= 300) {
            String idAE = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(1, 13));
            String idLig = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(13, 18));
            String description = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(18, 58));
            String partnerProd = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(58, 89));
            String categoryId = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(98, 118));
            String typeIdFonc = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(118, 148));
            String idFoncProd = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(148, 178));
            String idChourusProd = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(178, 196));
            String quantity = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(196, 211));
            String unit = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(211, 214));
            String grossPrice = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(214, 239));
            String unitPrice = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(239, 244));
            String taxCode = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(244, 246));
            String delivDate = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(246, 254));
            String crtNumber = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(254, 264));
            String ctrItemNumber = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(264, 274));
            String atgeLog = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(274, 278));
            String bePlant = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(278, 282));
            String bePurGroup = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(282, 285));
            String price = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(285, 300));
            sb.append("\t\t\t<ID_AE txt2xml:TxtValue=\"").append(idAE).append("\">").append(idAE.trim()).append("</ID_AE>\n");
            sb.append("\t\t\t<ID_LIG txt2xml:TxtValue=\"").append(idLig).append("\">").append(idLig.trim()).append("</ID_LIG>\n");
            if (description.trim().length() > 0) {
                sb.append("\t\t\t<DESCRIPTION txt2xml:TxtValue=\"").append(description).append("\">").append(description.trim()).append("</DESCRIPTION>\n");
            }
            if (partnerProd.trim().length() > 0) {
                sb.append("\t\t\t<PARTNER_PROD txt2xml:TxtValue=\"").append(partnerProd).append("\">").append(partnerProd.trim()).append("</PARTNER_PROD>\n");
            }
            if (categoryId.trim().length() > 0) {
                sb.append("\t\t\t<CATEGORY_ID txt2xml:TxtValue=\"").append(categoryId).append("\">").append(categoryId.trim()).append("</CATEGORY_ID>\n");
            }
            if (typeIdFonc.trim().length() > 0) {
                sb.append("\t\t\t<TYPE_ID_FONC txt2xml:TxtValue=\"").append(typeIdFonc).append("\">").append(typeIdFonc.trim()).append("</TYPE_ID_FONC>\n");
            }
            if (idFoncProd.trim().length() > 0) {
                sb.append("\t\t\t<ID_FONC_PROD txt2xml:TxtValue=\"").append(idFoncProd).append("\">").append(idFoncProd.trim()).append("</ID_FONC_PROD>\n");
            }
            if (idChourusProd.trim().length() > 0) {
                sb.append("\t\t\t<ID_CHORUS_PROD txt2xml:TxtValue=\"").append(idChourusProd).append("\">").append(idChourusProd.trim()).append("</ID_CHORUS_PROD>\n");
            }
            sb.append("\t\t\t<QUANTITY txt2xml:TxtValue=\"").append(quantity).append("\">").append(quantity.trim()).append("</QUANTITY>\n");
            if (unit.trim().length() > 0) {
                sb.append("\t\t\t<UNIT txt2xml:TxtValue=\"").append(unit).append("\">").append(unit.trim()).append("</UNIT>\n");
            }
            if (grossPrice.trim().length() > 0) {
                sb.append("\t\t\t<GROSS_PRICE txt2xml:TxtValue=\"").append(grossPrice).append("\">").append(grossPrice.trim()).append("</GROSS_PRICE>\n");
            }
            if (unitPrice.trim().length() > 0) {
                sb.append("\t\t\t<UNIT_PRICE txt2xml:TxtValue=\"").append(unitPrice).append("\">").append(unitPrice.trim()).append("</UNIT_PRICE>\n");
            }
            if (taxCode.trim().length() > 0) {
                sb.append("\t\t\t<TAX_CODE txt2xml:TxtValue=\"").append(taxCode).append("\">").append(taxCode.trim()).append("</TAX_CODE>\n");
            }
            sb.append("\t\t\t<DELIV_DATE txt2xml:TxtValue=\"").append(delivDate).append("\">").append(delivDate.trim()).append("</DELIV_DATE>\n");
            if (crtNumber.trim().length() > 0) {
                sb.append("\t\t\t<CTR_NUMBER txt2xml:TxtValue=\"").append(crtNumber).append("\">").append(crtNumber.trim()).append("</CTR_NUMBER>\n");
            }
            if (ctrItemNumber.trim().length() > 0) {
                sb.append("\t\t\t<CTR_ITEM_NUMBER txt2xml:TxtValue=\"").append(ctrItemNumber).append("\">").append(ctrItemNumber.trim()).append("</CTR_ITEM_NUMBER>\n");
            }
            if (atgeLog.trim().length() > 0) {
                sb.append("\t\t\t<STGE_LOC txt2xml:TxtValue=\"").append(atgeLog).append("\">").append(atgeLog.trim()).append("</STGE_LOC>\n");
            }
            sb.append("\t\t\t<BE_PLANT txt2xml:TxtValue=\"").append(bePlant).append("\">").append(bePlant.trim()).append("</BE_PLANT>\n");
            sb.append("\t\t\t<BE_PUR_GROUP txt2xml:TxtValue=\"").append(bePurGroup).append("\">").append(bePurGroup.trim()).append("</BE_PUR_GROUP>\n");
            if (price.trim().length() > 0) {
                sb.append("\t\t\t<PRICE txt2xml:TxtValue=\"").append(price).append("\">").append(price.trim()).append("</PRICE>\n");
            }
        } else {
            logger.debug((Object)"Pb makeTranformLine()");
        }
        sb.append("\t\t</POSTE>\n");
        return sb.toString().getBytes("ISO-8859-15");
    }

    private byte[] makeTranformImputation(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("\t\t<IMPUTATION txt2xml:LineTxt=\"" + nbLignesParcourues + "\"" + (line.length() < 591 ? " txt2xml:Length=\"" + line.length() + ";" + 591 + "\"" : "") + ">\n");
        if (line.length() >= 341) {
            String idAe = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(1, 13));
            String idLig = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(13, 18));
            String accCat = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(18, 23));
            String glCct = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(23, 33));
            String busArea = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(33, 37));
            String costCtr = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(37, 47));
            String assetNo = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(47, 59));
            String subNumber = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(59, 63));
            String wbsElem = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(63, 87));
            String cmmtItem = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(87, 101));
            String foncdCtr = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(101, 117));
            String fund = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(117, 127));
            String funcArea = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(127, 143));
            String activity = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(143, 167));
            String trcFonc = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(167, 191));
            String logInt = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(191, 199));
            String anaMin = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(199, 211));
            String locMin = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(211, 243));
            String natMin = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(243, 254));
            String cper = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(254, 269));
            String presage = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(269, 284));
            String axmin1 = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(284, 306));
            String axmin2 = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(306, 328));
            String resDoc = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(328, 338));
            String resItem = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(338, 341));
            sb.append("\t\t\t<ID_AE txt2xml:TxtValue=\"").append(idAe).append("\">").append(idAe.trim()).append("</ID_AE>\n");
            sb.append("\t\t\t<ID_LIG txt2xml:TxtValue=\"").append(idLig).append("\">").append(idLig.trim()).append("</ID_LIG>\n");
            sb.append("\t\t\t<ACC_CAT txt2xml:TxtValue=\"").append(accCat).append("\">").append(accCat.trim()).append("</ACC_CAT>\n");
            if (glCct.trim().length() > 0) {
                sb.append("\t\t\t<GL_ACCT txt2xml:TxtValue=\"").append(glCct).append("\">").append(glCct.trim()).append("</GL_ACCT>\n");
            }
            if (busArea.trim().length() > 0) {
                sb.append("\t\t\t<BUS_AREA txt2xml:TxtValue=\"").append(busArea).append("\">").append(busArea.trim()).append("</BUS_AREA>\n");
            }
            if (costCtr.trim().length() > 0) {
                sb.append("\t\t\t<COST_CTR txt2xml:TxtValue=\"").append(costCtr).append("\">").append(costCtr.trim()).append("</COST_CTR>\n");
            }
            if (assetNo.trim().length() > 0) {
                sb.append("\t\t\t<ASSET_NO txt2xml:TxtValue=\"").append(assetNo).append("\">").append(assetNo.trim()).append("</ASSET_NO>\n");
            }
            if (subNumber.trim().length() > 0) {
                sb.append("\t\t\t<SUB_NUMBER txt2xml:TxtValue=\"").append(subNumber).append("\">").append(subNumber.trim()).append("</SUB_NUMBER>\n");
            }
            if (wbsElem.trim().length() > 0) {
                sb.append("\t\t\t<WBS_ELEM txt2xml:TxtValue=\"").append(wbsElem).append("\">").append(wbsElem.trim()).append("</WBS_ELEM>\n");
            }
            if (cmmtItem.trim().length() > 0) {
                sb.append("\t\t\t<CMMT_ITEM txt2xml:TxtValue=\"").append(cmmtItem).append("\">").append(cmmtItem.trim()).append("</CMMT_ITEM>\n");
            }
            if (foncdCtr.trim().length() > 0) {
                sb.append("\t\t\t<FUNDS_CTR txt2xml:TxtValue=\"").append(foncdCtr).append("\">").append(foncdCtr.trim()).append("</FUNDS_CTR>\n");
            }
            if (fund.trim().length() > 0) {
                sb.append("\t\t\t<FUND txt2xml:TxtValue=\"").append(fund).append("\">").append(fund.trim()).append("</FUND>\n");
            }
            if (funcArea.trim().length() > 0) {
                sb.append("\t\t\t<FUNC_AREA txt2xml:TxtValue=\"").append(funcArea).append("\">").append(funcArea.trim()).append("</FUNC_AREA>\n");
            }
            if (activity.trim().length() > 0) {
                sb.append("\t\t\t<ACTIVITY txt2xml:TxtValue=\"").append(activity).append("\">").append(activity.trim()).append("</ACTIVITY>\n");
            }
            if (trcFonc.trim().length() > 0) {
                sb.append("\t\t\t<TRC_FONC txt2xml:TxtValue=\"").append(trcFonc).append("\">").append(trcFonc.trim()).append("</TRC_FONC>\n");
            }
            if (logInt.trim().length() > 0) {
                sb.append("\t\t\t<LOC_INT txt2xml:TxtValue=\"").append(logInt).append("\">").append(logInt.trim()).append("</LOC_INT>\n");
            }
            if (anaMin.trim().length() > 0) {
                sb.append("\t\t\t<ANA_MIN txt2xml:TxtValue=\"").append(anaMin).append("\">").append(anaMin.trim()).append("</ANA_MIN>\n");
            }
            if (locMin.trim().length() > 0) {
                sb.append("\t\t\t<LOC_MIN txt2xml:TxtValue=\"").append(locMin).append("\">").append(locMin.trim()).append("</LOC_MIN>\n");
            }
            if (natMin.trim().length() > 0) {
                sb.append("\t\t\t<NAT_MIN txt2xml:TxtValue=\"").append(natMin).append("\">").append(natMin.trim()).append("</NAT_MIN>\n");
            }
            if (cper.trim().length() > 0) {
                sb.append("\t\t\t<CPER txt2xml:TxtValue=\"").append(cper).append("\">").append(cper.trim()).append("</CPER>\n");
            }
            if (presage.trim().length() > 0) {
                sb.append("\t\t\t<PRESAGE txt2xml:TxtValue=\"").append(presage).append("\">").append(presage.trim()).append("</PRESAGE>\n");
            }
            if (axmin1.trim().length() > 0) {
                sb.append("\t\t\t<AXMIN1 txt2xml:TxtValue=\"").append(axmin1).append("\">").append(axmin1.trim()).append("</AXMIN1>\n");
            }
            if (axmin2.trim().length() > 0) {
                sb.append("\t\t\t<AXMIN2 txt2xml:TxtValue=\"").append(axmin2).append("\">").append(axmin2.trim()).append("</AXMIN2>\n");
            }
            if (resDoc.trim().length() > 0) {
                sb.append("\t\t\t<RES_DOC txt2xml:TxtValue=\"").append(resDoc).append("\">").append(resDoc.trim()).append("</RES_DOC>\n");
            }
            if (resItem.trim().length() > 0) {
                sb.append("\t\t\t<RES_ITEM txt2xml:TxtValue=\"").append(resItem).append("\">").append(resItem.trim()).append("</RES_ITEM>\n");
            }
        } else {
            logger.debug((Object)"Pb makeTranformImputation()");
        }
        sb.append("\t\t</IMPUTATION>\n");
        return sb.toString().getBytes("ISO-8859-15");
    }

    private byte[] makeTranformTexte(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("\t\t<TEXTE txt2xml:LineTxt=\"" + nbLignesParcourues + "\"" + (line.length() < 404 ? " txt2xml:Length=\"" + line.length() + ";" + 404 + "\"" : "") + ">\n");
        if (line.length() >= 154) {
            String idAe = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(1, 13));
            String idLig = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(13, 18));
            String textId = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(18, 22));
            String texteLigne = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(22, 154));
            sb.append("\t\t\t<ID_AE txt2xml:TxtValue=\"").append(idAe).append("\">").append(idAe.trim()).append("</ID_AE>\n");
            sb.append("\t\t\t<ID_LIG txt2xml:TxtValue=\"").append(idLig).append("\">").append(idLig.trim()).append("</ID_LIG>\n");
            sb.append("\t\t\t<TEXT_ID txt2xml:TxtValue=\"").append(textId).append("\">").append(textId.trim()).append("</TEXT_ID>\n");
            sb.append("\t\t\t<TEXT_LINE txt2xml:TxtValue=\"").append(texteLigne).append("\">").append(texteLigne.trim()).append("</TEXT_LINE>\n");
        } else {
            logger.debug((Object)"Pb makeTranformTexte()");
        }
        sb.append("\t\t</TEXTE>\n");
        return sb.toString().getBytes("ISO-8859-15");
    }

    private byte[] makeTranformPartenaire(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("\t\t<PARTENAIRE txt2xml:LineTxt=\"" + nbLignesParcourues + "\"" + (line.length() < 620 ? " txt2xml:Length=\"" + line.length() + ";" + 620 + "\"" : "") + ">\n");
        if (line.length() >= 370) {
            String idAe = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(1, 13));
            String idLig = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(13, 18));
            String partnairFct = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(18, 26));
            String partnairTyp = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(26, 30));
            String idFoncPartner = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(30, 110));
            String idChourusPartner = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(110, 120));
            String addrType = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(120, 121));
            String addrOrigin = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(121, 122));
            String bulding = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(122, 132));
            String floor = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(132, 142));
            String roomNo = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(142, 152));
            String name = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(152, 187));
            String city = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(187, 222));
            String postlCod = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(222, 232));
            String street = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(232, 267));
            String houseNo = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(267, 277));
            String country = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(277, 280));
            String telNumber = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(280, 310));
            String faxNumber = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(310, 340));
            String email = StringUtilities.escapeSpecialsCharactersAndAccentsToDecimal((String)line.substring(340, 370));
            sb.append("\t\t\t<ID_AE txt2xml:TxtValue=\"").append(idAe).append("\">").append(idAe.trim()).append("</ID_AE>\n");
            if (idLig.trim().length() > 0) {
                sb.append("\t\t\t<ID_LIG txt2xml:TxtValue=\"").append(idLig).append("\">").append(idLig.trim()).append("</ID_LIG>\n");
            }
            sb.append("\t\t\t<PARTNER_FCT txt2xml:TxtValue=\"").append(partnairFct).append("\">").append(partnairFct.trim()).append("</PARTNER_FCT>\n");
            if (partnairTyp.trim().length() > 0) {
                sb.append("\t\t\t<PARTNER_TYP txt2xml:TxtValue=\"").append(partnairTyp).append("\">").append(partnairTyp.trim()).append("</PARTNER_TYP>\n");
            }
            if (idFoncPartner.trim().length() > 0) {
                sb.append("\t\t\t<ID_FONC_PARTNER txt2xml:TxtValue=\"").append(idFoncPartner).append("\">").append(idFoncPartner.trim()).append("</ID_FONC_PARTNER>\n");
            }
            if (idChourusPartner.trim().length() > 0) {
                sb.append("\t\t\t<ID_CHORUS_PARTNER txt2xml:TxtValue=\"").append(idChourusPartner).append("\">").append(idChourusPartner.trim()).append("</ID_CHORUS_PARTNER>\n");
            }
            sb.append("\t\t\t<ADDR_TYPE txt2xml:TxtValue=\"").append(addrType).append("\">").append(addrType.trim()).append("</ADDR_TYPE>\n");
            sb.append("\t\t\t<ADDR_ORIGIN txt2xml:TxtValue=\"").append(addrOrigin).append("\">").append(addrOrigin.trim()).append("</ADDR_ORIGIN>\n");
            if (bulding.trim().length() > 0) {
                sb.append("\t\t\t<BUILDING txt2xml:TxtValue=\"").append(bulding).append("\">").append(bulding.trim()).append("</BUILDING>\n");
            }
            if (floor.trim().length() > 0) {
                sb.append("\t\t\t<FLOOR txt2xml:TxtValue=\"").append(floor).append("\">").append(floor.trim()).append("</FLOOR>\n");
            }
            if (roomNo.trim().length() > 0) {
                sb.append("\t\t\t<ROOM_NO txt2xml:TxtValue=\"").append(roomNo).append("\">").append(roomNo.trim()).append("</ROOM_NO>\n");
            }
            if (name.trim().length() > 0) {
                sb.append("\t\t\t<NAME txt2xml:TxtValue=\"").append(name).append("\">").append(name.trim()).append("</NAME>\n");
            }
            if (city.trim().length() > 0) {
                sb.append("\t\t\t<CITY txt2xml:TxtValue=\"").append(city).append("\">").append(city.trim()).append("</CITY>\n");
            }
            if (postlCod.trim().length() > 0) {
                sb.append("\t\t\t<POSTL_COD txt2xml:TxtValue=\"").append(postlCod).append("\">").append(postlCod.trim()).append("</POSTL_COD>\n");
            }
            if (street.trim().length() > 0) {
                sb.append("\t\t\t<STREET txt2xml:TxtValue=\"").append(street).append("\">").append(street.trim()).append("</STREET>\n");
            }
            if (houseNo.trim().length() > 0) {
                sb.append("\t\t\t<HOUSE_NO txt2xml:TxtValue=\"").append(houseNo).append("\">").append(houseNo.trim()).append("</HOUSE_NO>\n");
            }
            if (country.trim().length() > 0) {
                sb.append("\t\t\t<COUNTRY txt2xml:TxtValue=\"").append(country).append("\">").append(country.trim()).append("</COUNTRY>\n");
            }
            if (telNumber.trim().length() > 0) {
                sb.append("\t\t\t<TEL_NUMBR txt2xml:TxtValue=\"").append(telNumber).append("\">").append(telNumber.trim()).append("</TEL_NUMBR>\n");
            }
            if (faxNumber.trim().length() > 0) {
                sb.append("\t\t\t<FAX_NUMBER txt2xml:TxtValue=\"").append(faxNumber).append("\">").append(faxNumber.trim()).append("</FAX_NUMBER>\n");
            }
            if (email.trim().length() > 0) {
                sb.append("\t\t\t<E_MAIL txt2xml:TxtValue=\"").append(email).append("\">").append(email.trim()).append("</E_MAIL>\n");
            }
        } else {
            logger.debug((Object)"Pb makeTranformPartenaire()");
        }
        sb.append("\t\t</PARTENAIRE>\n");
        return sb.toString().getBytes("ISO-8859-15");
    }

    private byte[] makeTranformLineInconnue(String line, int nbLignesParcourues) throws UnsupportedEncodingException {
        System.out.println("makeTranformLine : " + line);
        StringBuffer sb = new StringBuffer("\t\t<LIGNE_INCONNUE txt2xml:LineTxt=\"" + nbLignesParcourues + "\">\n");
        if (line.trim().length() != 0) {
            sb.append("\t\t\t<LIGNE_INCONNUE txt2xml:TxtValue=\"").append(line).append("\">").append(line.trim()).append("</LIGNE_INCONNUE>\n");
        }
        sb.append("\t\t</LIGNE_INCONNUE>\n");
        return sb.toString().getBytes("ISO-8859-15");
    }
}

