/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.utils;

import fr.gouv.finances.dgfip.xemelios.utils.DBHashSwapEngine;
import fr.gouv.finances.dgfip.xemelios.utils.HTHashSwapEngine;
import fr.gouv.finances.dgfip.xemelios.utils.HashSwapEngine;
import fr.gouv.finances.dgfip.xemelios.utils.HashSwapEngineException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashSwap<T> {
    private HashSwapEngine<T> engine;

    public HashSwap() {
        this.engine = new HTHashSwapEngine();
    }

    public HashSwap(Class<T> tclass) {
        try {
            this.engine = new DBHashSwapEngine<T>(tclass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void put(String key, T value) throws HashSwapEngineException {
        this.engine.put(key, value);
    }

    public T get(String key) throws HashSwapEngineException {
        return this.engine.get(key);
    }

    public void putAll(Map<String, T> ht) throws HashSwapEngineException {
        for (String key : ht.keySet()) {
            this.put(key, ht.get(key));
        }
    }

    public boolean containsKey(String key) throws HashSwapEngineException {
        return this.engine.containsKey(key);
    }

    public T remove(String key) throws HashSwapEngineException {
        return this.engine.remove(key);
    }

    public int size() throws HashSwapEngineException {
        return this.engine.size();
    }

    public void destruct() throws HashSwapEngineException {
        this.engine.destruct();
    }

    public static void main(String[] args) {
        HashSwap<Integer> moi = new HashSwap<Integer>();
        try {
            moi.put("1", 1);
            moi.put("2", 2);
            HashSwap<String> moi2 = new HashSwap<String>();
            Map<String, String> variables = System.getenv();
            moi2.putAll(variables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

