/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.txt2xml;

import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class AbstractTxt2Xml {
    private static final Logger logger = Logger.getLogger(AbstractTxt2Xml.class);
    private static final DecimalFormat df = new DecimalFormat("##0.0000");
    private static final String ENCODING_TXT = "UTF-8";
    private static final String ENCODING_XML = "ISO-8859-15";
    private static final transient String SEP = "|";
    private static final String TABLE_FEN = "FEN_DONNEES_TRI";
    private static final String SCRIPT_CREATE_FEN_DONNEES_TRI = "CREATE TEMPORARY TABLE IF NOT EXISTS FEN_DONNEES_TRI (FEN_CLE VARCHAR(50) not null, FEN_DONNEES VARCHAR(2000) not null, FEN_NUM_LIGNE VARCHAR(10) not null, INDEX IX_FEN (FEN_CLE))";
    protected static final String SCRIPT_SELECT_FEN_DONNEES_TRI = "SELECT FEN_DONNEES,FEN_NUM_LIGNE FROM FEN_DONNEES_TRI ORDER BY FEN_CLE ASC";

    public String getAmount(String montant) {
        Double mt = 0.0;
        try {
            if (montant.trim().length() > 0) {
                mt = Double.parseDouble(montant);
            }
            return df.format(mt / 100.0);
        }
        catch (NumberFormatException ex) {
            logger.debug((Object)("Probl\u00e8me lors du formattage du montant (" + montant + ") : " + ex.getLocalizedMessage()));
            return montant;
        }
    }

    public String getDateLong(String date) {
        if (date.length() == 8) {
            String annee = date.substring(0, 4);
            String mois = date.substring(4, 6);
            String jour = date.substring(6, 8);
            return new StringBuffer(annee).append("-").append(mois).append("-").append(jour).toString();
        }
        logger.debug((Object)("Probl\u00e8me lors du formattage de la date (" + date + ") "));
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataBaseDonnees(Connection con) {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(SCRIPT_CREATE_FEN_DONNEES_TRI);
            ps.execute();
            ps = con.prepareStatement("TRUNCATE TABLE FEN_DONNEES_TRI");
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertionDonneesPourTri(File fDonnees, Connection con) {
        Statement ps = null;
        OutputStreamWriter osw = null;
        File fSQL = new File(FileUtils.getTempDir(), "insert_donnees.txt");
        try {
            Charset csReader = Charset.forName(ENCODING_TXT);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fDonnees), csReader);
            BufferedReader br = new BufferedReader(reader);
            Charset csWriter = Charset.forName(ENCODING_XML);
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(fSQL), csWriter);
            String line = br.readLine();
            int nbLignesParcourues = 0;
            while (line != null) {
                ++nbLignesParcourues;
                if (line.trim().length() > 0) {
                    String typeEnregistrement = line.substring(0, 1);
                    String idAe = line.substring(1, 13);
                    String cle = idAe.trim() + "-" + typeEnregistrement.trim();
                    String donnees = line.substring(0, line.length() - 1);
                    osw.write(cle + SEP + donnees + SEP + nbLignesParcourues + "\n");
                }
                line = br.readLine();
            }
            osw.flush();
            osw.close();
            ps = con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_FEN + " FIELDS TERMINATED BY '" + SEP + "'");
            ps.execute();
            fSQL.delete();
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier FEN n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + fDonnees.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            logger.debug((Object)("SQLException sur le fichier " + fSQL.getAbsolutePath() + " !"), e.getCause());
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }
}

