/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.OptionModel;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialKeyModel
implements NoeudModifiable,
Comparable {
    Logger logger = Logger.getLogger(SpecialKeyModel.class);
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "special-key";
    public static final transient QName QN = new QName("special-key");
    private int pos = 0;
    private String id;
    private String libelle;
    private String path;
    private String transform;
    private Vector<OptionModel> descriptions = new Vector();
    private Hashtable<String, OptionModel> hDescriptions = new Hashtable();
    private String configXPath = null;

    public SpecialKeyModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        OptionModel om = (OptionModel)child;
        if (this.hDescriptions.containsKey(om.getValue())) {
            OptionModel old = this.hDescriptions.get(om.getValue());
            this.descriptions.remove(old);
            this.hDescriptions.remove(old.getValue());
        }
        om.setParentAsNoeudModifiable(this);
        this.descriptions.add(om);
        this.hDescriptions.put(om.getValue(), om);
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        String string = this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        if (attributes.getValue("pos") != null) {
            this.pos = attributes.getIntValue("pos");
        }
        this.libelle = attributes.getValue("libelle") != null ? attributes.getValue("libelle") : this.libelle;
        this.path = attributes.getValue("path") != null ? attributes.getValue("path") : this.path;
        this.transform = attributes.getValue("transform") != null ? attributes.getValue("transform") : this.transform;
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.getId() == null || this.getId().length() == 0) {
            throw new InvalidXmlDefinition("//special-key/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + "/" + TAG + ")");
        }
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getPath() {
        return this.path;
    }

    public int getPos() {
        return this.pos;
    }

    public String getId() {
        if (this.id == null) {
            this.id = Integer.toString(this.pos);
        }
        return this.id;
    }

    public SpecialKeyModel clone() {
        SpecialKeyModel dfm = new SpecialKeyModel(QN);
        dfm.id = this.id;
        dfm.pos = this.pos;
        dfm.libelle = this.libelle;
        dfm.path = this.path;
        dfm.transform = this.transform;
        for (OptionModel om : this.descriptions) {
            try {
                dfm.addChild((XmlMarshallable)om, OptionModel.QN);
            }
            catch (Throwable t) {
                this.logger.error((Object)"clone().option", t);
            }
        }
        return dfm;
    }

    public Vector<OptionModel> getDescriptions() {
        return this.descriptions;
    }

    public String getTransform() {
        return this.transform;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof SpecialKeyModel) {
            SpecialKeyModel other = (SpecialKeyModel)o;
            if (this.pos < other.pos) {
                return -1;
            }
            if (this.pos == other.pos) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public String transformValue(String value) {
        String ret = value;
        if ("normalizeMonth".equals(this.transform)) {
            int i = Integer.parseInt(value);
            if (i < 10) {
                return "0" + Integer.toString(i);
            }
            ret = Integer.toString(i);
        } else if ("Identity".equals(this.transform)) {
            ret = value;
        }
        if ("UpperCase".equals(this.transform)) {
            ret = value.toUpperCase();
        }
        if ("LowerCase".equals(this.transform)) {
            ret = value.toLowerCase();
        }
        return ret;
    }

    public String getDescriptionOfValue(String value) {
        for (OptionModel om : this.descriptions) {
            if (!om.getValue().equals(value)) continue;
            return om.getLibelle();
        }
        return value;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            this.logger.error((Object)("Erreur lors de la mise \u00ef\u00bf\u00bd jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        return new String[]{"id"};
    }

    public String getIdValue() {
        return this.getId();
    }

    public void resetCharData() {
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/special-key[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return (XmlMarshallable)this.hDescriptions.get(atts.getValue("value"));
    }

    public QName getQName() {
        return QN;
    }
}

