/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereRefModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.OptionModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PropertyModel;
import fr.gouv.finances.dgfip.xemelios.common.config.RechercheModel;
import fr.gouv.finances.dgfip.xemelios.ui.ListDisplayable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginModel
implements NoeudModifiable,
Comparable,
ListDisplayable {
    private static Logger logger = Logger.getLogger(PluginModel.class);
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "plugin";
    public static final transient QName QN = new QName("plugin");
    public static final transient String TYPE_SEARCH = "search";
    public static final transient String TYPE_EXPORT = "export";
    private String id;
    private String pluginType;
    private String pluginTitle;
    private String pluginClass;
    private String availablePersistences;
    private boolean sumPossible = false;
    private Vector<CritereModel> criteres = new Vector();
    private HashMap<String, CritereModel> hCriteres = new HashMap();
    private Vector<CritereRefModel> criteresOp = new Vector();
    private HashMap<String, CritereRefModel> hCriteresOp = new HashMap();
    private Vector<PropertyModel> properties = new Vector();
    private HashMap<String, PropertyModel> hProperties = new HashMap();
    private OptionModel entete;
    private String separator;
    private ListeResultatModel listeResultat;
    private HashSet<String> persistences = null;
    private String configXPath = null;

    public PluginModel(QName tag) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (CritereRefModel.QN.equals(tagName)) {
            CritereRefModel cm = (CritereRefModel)child;
            if (this.hCriteresOp.containsKey(cm.getId())) {
                CritereRefModel old = this.hCriteresOp.get(cm.getId());
                this.criteresOp.remove(old);
                this.hCriteresOp.remove(old.getId());
            }
            cm.setParentAsNoeudModifiable(this);
            this.criteresOp.add(cm);
            this.hCriteresOp.put(cm.getId(), cm);
        } else if (CritereModel.QN.equals(tagName)) {
            CritereModel cm = (CritereModel)child;
            if (this.hCriteres.containsKey(cm.getId())) {
                CritereModel old = this.hCriteres.get(cm.getId());
                this.criteres.remove(old);
                this.hCriteres.remove(old.getId());
            }
            cm.setParentAsNoeudModifiable(this);
            this.criteres.add(cm);
            this.hCriteres.put(cm.getId(), cm);
        } else if (PropertyModel.QN.equals(tagName)) {
            PropertyModel pm = (PropertyModel)child;
            if (this.hProperties.containsKey(pm.getName())) {
                PropertyModel old = this.hProperties.get(pm.getName());
                this.properties.remove(old);
                this.hProperties.remove(old.getName());
            }
            pm.setParentAsNoeudModifiable(this);
            this.properties.add(pm);
            this.hProperties.put(pm.getName(), pm);
        } else if (DocumentsMapping.HEADER.equals(tagName)) {
            this.entete = (OptionModel)child;
            this.entete.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.LISTE_EXPORT.equals(tagName)) {
            this.listeResultat = (ListeResultatModel)child;
            this.listeResultat.setParentAsNoeudModifiable(this);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        this.pluginType = attributes.getValue("type") != null ? attributes.getValue("type") : this.pluginType;
        this.pluginTitle = attributes.getValue("title") != null ? attributes.getValue("title") : this.pluginTitle;
        this.pluginClass = attributes.getValue("class") != null ? attributes.getValue("class") : this.pluginClass;
        this.separator = attributes.getValue("separator") != null ? attributes.getValue("separator") : this.separator;
        String string = this.availablePersistences = attributes.getValue("available-persistences") != null ? attributes.getValue("available-persistences") : this.availablePersistences;
        if (attributes.getValue("sum-possible") != null) {
            this.sumPossible = attributes.getBooleanValue("sum-possible");
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidXmlDefinition("//plugin/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + ").");
        }
        if (this.pluginClass == null || this.pluginClass.length() == 0) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + "/@class is required.");
        }
        if (this.pluginTitle == null || this.pluginTitle.length() == 0) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + "/@title is required.");
        }
        if (this.pluginType == null || this.pluginType.length() == 0) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + "/@type is required");
        }
        if (TYPE_SEARCH.equals(this.pluginType) && this.separator != null) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + ": @separator is forbidden when @type='search'.");
        }
        if (TYPE_EXPORT.equals(this.pluginType) && this.sumPossible) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + ": @sum-possible is forbidden when @type='export'.");
        }
        if (TYPE_EXPORT.equals(this.pluginType) && this.listeResultat == null) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + ": <liste-export/> is required when @type='export'.");
        }
        if (TYPE_SEARCH.equals(this.pluginType) || this.entete != null) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + ": <header/> is forbidden when @type='search'.");
        }
        if (TYPE_SEARCH.equals(this.pluginType) && this.criteres.size() == 0) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + ": at least one <critere/> is required when @type='search'.");
        }
        for (CritereModel critereModel : this.criteres) {
            critereModel.validate();
        }
        for (CritereRefModel critereRefModel : this.criteresOp) {
            critereRefModel.validate();
        }
        for (PropertyModel propertyModel : this.properties) {
            propertyModel.validate();
        }
        if (this.listeResultat != null) {
            this.listeResultat.validate();
        }
    }

    public PluginModel clone() {
        PluginModel pm = new PluginModel(QN);
        pm.id = this.id;
        pm.pluginClass = this.pluginClass;
        pm.pluginTitle = this.pluginTitle;
        pm.pluginType = this.pluginType;
        pm.availablePersistences = this.availablePersistences;
        pm.sumPossible = this.sumPossible;
        for (PropertyModel propertyModel : this.properties) {
            try {
                pm.addChild((XmlMarshallable)propertyModel, PropertyModel.QN);
            }
            catch (SAXException ignore) {
                logger.error((Object)"clone().property", (Throwable)ignore);
            }
        }
        for (CritereModel critereModel : this.criteres) {
            try {
                pm.addChild((XmlMarshallable)critereModel.clone(), CritereModel.QN);
            }
            catch (SAXException ignore) {
                logger.error((Object)"clone().critere", (Throwable)ignore);
            }
        }
        for (CritereRefModel critereRefModel : this.criteresOp) {
            try {
                pm.addChild((XmlMarshallable)critereRefModel.clone(), CritereRefModel.QN);
            }
            catch (SAXException ignore) {
                logger.error((Object)"clone().critere-ref", (Throwable)ignore);
            }
        }
        pm.separator = this.separator;
        try {
            if (this.entete != null) {
                pm.addChild((XmlMarshallable)this.entete.clone(), DocumentsMapping.HEADER);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().entete", t);
        }
        try {
            if (this.listeResultat != null) {
                pm.addChild((XmlMarshallable)this.listeResultat.clone(), DocumentsMapping.LISTE_EXPORT);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().listeResultat", t);
        }
        return pm;
    }

    public Vector<CritereModel> getCriteres() {
        return this.criteres;
    }

    public Vector<CritereRefModel> getCriteresOp() {
        return this.criteresOp;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public String getPluginTitle() {
        return this.pluginTitle;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof RechercheModel) {
            RechercheModel other = (RechercheModel)o;
            return this.getPluginTitle().compareTo(other.getName());
        }
        if (o instanceof PluginModel) {
            PluginModel other = (PluginModel)o;
            return this.getPluginTitle().compareTo(other.getPluginTitle());
        }
        return 0;
    }

    public String toString() {
        return this.getPluginTitle();
    }

    public Vector<PropertyModel> getProperties() {
        return this.properties;
    }

    public String getSeparator() {
        return this.separator;
    }

    public OptionModel getEntete() {
        return this.entete;
    }

    public ListeResultatModel getListeExport() {
        return this.listeResultat;
    }

    @Override
    public String getResource() {
        if (TYPE_SEARCH.equals(this.getPluginType())) {
            return "fr/gouv/finances/cp/xemelios/ui/resources/list-search-plug.png";
        }
        if (TYPE_EXPORT.equals(this.getPluginType())) {
            return "fr/gouv/finances/cp/xemelios/ui/resources/list-export-plug.png";
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.toString();
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    public String getAvailablePersistences() {
        return this.availablePersistences;
    }

    public void setAvailablePersistences(String availablePersistences) {
        this.availablePersistences = availablePersistences;
    }

    public boolean isAvailableFor(String persistence) {
        if (this.persistences == null) {
            this.persistences = new HashSet();
            if (this.availablePersistences != null) {
                StringTokenizer st = new StringTokenizer(this.availablePersistences, ",; ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    this.persistences.add(s);
                }
            }
        }
        return this.persistences.contains(persistence);
    }

    public void setSumPossible(boolean isSumPossible) {
        this.sumPossible = isSumPossible;
    }

    public boolean isSumPossible() {
        return this.sumPossible;
    }

    public String getId() {
        return this.id;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00ef\u00bf\u00bd jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("critere-optionnel".equals(tagName)) {
            return this.hCriteresOp.get(id);
        }
        if ("critere".equals(tagName)) {
            return this.hCriteres.get(id);
        }
        if ("property".equals(tagName)) {
            return this.hProperties.get(id);
        }
        if ("header".equals(tagName)) {
            return this.entete;
        }
        if ("liste-export".equals(tagName)) {
            return this.listeResultat;
        }
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("critere-optionnel".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("critere".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("property".equals(childTagName)) {
            return new String[]{"name"};
        }
        return null;
    }

    public void resetCharData() {
    }

    public String getIdValue() {
        return this.getId();
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/plugin[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (CritereRefModel.QN.equals(name)) {
            return (XmlMarshallable)this.hCriteresOp.get(atts.getValue("id"));
        }
        if (CritereModel.QN.equals(name)) {
            return (XmlMarshallable)this.hCriteres.get(atts.getValue("id"));
        }
        if (PropertyModel.QN.equals(name)) {
            return (XmlMarshallable)this.hProperties.get(atts.getValue("name"));
        }
        if (DocumentsMapping.HEADER.equals(name)) {
            return this.entete;
        }
        if (DocumentsMapping.LISTE_EXPORT.equals(name)) {
            return this.listeResultat;
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

