/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class Loader {
    private static final Logger logger = Logger.getLogger(Loader.class);
    private static DocumentsModel cache = null;

    protected static DocumentsModel getDocsInfos(String repertoires) throws SAXException, ParserConfigurationException, IOException {
        DocumentsModel ret = cache;
        if (ret == null) {
            File[] fichiers;
            File dir;
            String[] dirs;
            for (String repertoire : dirs = repertoires.split(",")) {
                dir = new File(repertoire);
                logger.info((Object)("Searching " + repertoire));
                if (!dir.exists()) {
                    logger.info((Object)(repertoire + " does not exists."));
                    continue;
                }
                fichiers = dir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        boolean ret = name.toUpperCase().endsWith(".XML") && !"build.xml".equals(name);
                        return ret;
                    }
                });
                if (fichiers == null) {
                    logger.info((Object)("No file found in " + repertoire));
                    return null;
                }
                DocumentsParser dp = new DocumentsParser();
                for (int i = 0; i < fichiers.length; ++i) {
                    logger.debug((Object)("parsing " + fichiers[i].getAbsolutePath()));
                    try {
                        dp.parse(fichiers[i]);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("while parsing " + fichiers[i].getAbsolutePath()), (Throwable)ex);
                    }
                    DocumentsModel dm = (DocumentsModel)dp.getMarshallable();
                    if (ret == null) {
                        ret = dm;
                        for (DocumentModel docModel : ret.getDocuments()) {
                            docModel.setBaseDirectory(repertoire);
                        }
                        continue;
                    }
                    for (DocumentModel docModel : dm.getDocuments()) {
                        docModel.setBaseDirectory(repertoire);
                        ret.addChild((XmlMarshallable)docModel, DocumentModel.QN);
                    }
                }
            }
            for (String repertoire : dirs) {
                dir = new File(repertoire);
                logger.info((Object)("Searching " + repertoire));
                if (!dir.exists()) {
                    logger.info((Object)(repertoire + " does not exists."));
                    continue;
                }
                fichiers = dir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toUpperCase().endsWith(".EXML");
                    }
                });
                if (fichiers == null) {
                    logger.info((Object)("No file found in " + repertoire));
                    return null;
                }
                for (File f : fichiers) {
                    logger.debug((Object)("parsing " + f.getAbsolutePath()));
                    DocumentsParser dp = new DocumentsParser();
                    dp.setInitialData(ret);
                    dp.parse(f);
                    ret = (DocumentsModel)dp.getMarshallable();
                    for (DocumentModel docModel : ret.getDocuments()) {
                        if (docModel.getBaseDirectory() != null) continue;
                        docModel.setBaseDirectory(repertoire);
                    }
                }
            }
            cache = ret;
        }
        return ret;
    }

    public static DocumentsModel getDocumentsInfos(String repertoires) throws SAXException, ParserConfigurationException, IOException {
        DocumentsModel ret = Loader.getDocsInfos(repertoires);
        try {
            ret.validate();
        }
        catch (Throwable t) {
            logger.error((Object)("while loading config files: " + t));
            t.printStackTrace();
            ret = new DocumentsModel(DocumentsModel.QN);
        }
        return ret;
    }

    public static void flushLoadedConfig() {
        cache = null;
    }
}

