/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PersonnalConfigurationModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PropertyModel;
import fr.gouv.finances.dgfip.xemelios.common.config.RechercheModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SavedRequestsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SelectModel;
import org.apache.commons.lang.StringEscapeUtils;

public class ConfigModelPatcher {
    public static void patchSharedConfig(PersonnalConfigurationModel sharedConfig) {
        for (SavedRequestsModel srm : sharedConfig.getAllSavedRequests()) {
            for (RechercheModel rm : srm.getRecherches()) {
                ConfigModelPatcher.patchRechercheModel(rm);
            }
        }
    }

    public static void patchRechercheModel(RechercheModel rm) {
        rm.setName(ConfigModelPatcher.patchString(rm.getName()));
        for (CritereModel cm : rm.getCriteres()) {
            for (XmlMarshallable m : cm.getInputs()) {
                if (!(m instanceof SelectModel)) continue;
                SelectModel im = (SelectModel)m;
                im.setValue(ConfigModelPatcher.patchString(im.getValue()));
            }
            for (PropertyModel pm : cm.getProperties()) {
                pm.setValue(ConfigModelPatcher.patchString(pm.getValue()));
            }
        }
    }

    public static String patchString(String s) {
        if (s == null) {
            return null;
        }
        String sTmp = StringEscapeUtils.unescapeXml(s);
        while (!s.equals(sTmp)) {
            s = sTmp;
            sTmp = StringEscapeUtils.unescapeXml(s);
        }
        return sTmp;
    }
}

