/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.utils;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class ClassPathUtils {
    private static final Logger logger = Logger.getLogger(ClassPathUtils.class);

    public static String displayClassPathInfos() {
        StringBuilder sb = new StringBuilder();
        ClassLoader cl = ClassPathUtils.class.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URL[] urls;
            URLClassLoader ucl = (URLClassLoader)cl;
            for (URL url : urls = ucl.getURLs()) {
                sb.append(ClassPathUtils.displayUrlInfos(url));
            }
        }
        return sb.toString();
    }

    private static String displayUrlInfos(URL url) {
        if (url.toExternalForm().endsWith(".jar")) {
            StringBuffer sb = new StringBuffer();
            sb.append(url).append("\n");
            try {
                String sUrl = url.toString().replaceAll(" ", "%20");
                if (sUrl.startsWith("file:") && !sUrl.startsWith("file:/")) {
                    sUrl = "file:/".concat(sUrl.substring(5));
                }
                url = new URL(sUrl);
                JarFile jf = new JarFile(new File(url.toURI()));
                Manifest mf = jf.getManifest();
                Attributes att = mf.getMainAttributes();
                for (Map.Entry<Object, Object> entry : att.entrySet()) {
                    sb.append("\t").append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sb.toString();
        }
        return "";
    }

    private static String makeUnderscored(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append("-");
        }
        return sb.toString();
    }

    private ClassPathUtils() {
    }
}

