/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class HtmlTableWriter {
    private static final Logger logger = Logger.getLogger(HtmlTableWriter.class);
    private Writer rawWriter;
    private PrintWriter pw;
    private static String modele;
    public static final Integer TEXT_CELLFORMAT;
    public static final Integer INTEGER_CELLFORMAT;
    public static final Integer FLOAT_CELLFORMAT;
    public static final Integer DATE_CELLFORMAT;
    private String fileName;

    public HtmlTableWriter(Writer writer, String fileName) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.fileName = fileName;
        logger.debug((Object)("HtmlTableWriter<" + fileName + ">.open()"));
        StringBuffer sb = new StringBuffer();
        if (modele == null) {
            String dirRessources = System.getProperty("xemelios.resources.location", "C:\\");
            String filePath = dirRessources + "/modeleExcelHtml.xls";
            try {
                StringBuffer fileData = new StringBuffer(1000);
                BufferedReader reader = new BufferedReader(new FileReader(filePath));
                char[] buf = new char[1024];
                int numRead = 0;
                while ((numRead = reader.read(buf)) != -1) {
                    fileData.append(buf, 0, numRead);
                }
                reader.close();
                modele = fileData.toString();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        if (modele != null) {
            sb.append(modele);
        }
        sb.append("<BODY>");
        sb.append("<TABLE  border=\"1\">");
        this.pw.write(sb.toString());
    }

    public static String buildCell(String data, Integer cellFormat, Integer level) {
        StringBuffer sb = new StringBuffer();
        if (cellFormat == TEXT_CELLFORMAT && level > 2) {
            sb.append("<TD class=\"axyusText\">");
        } else if (cellFormat == INTEGER_CELLFORMAT) {
            sb.append("<TD class=\"axyusInteger\">");
        } else if (cellFormat == FLOAT_CELLFORMAT) {
            sb.append("<TD class=\"axyusFloat\">");
        } else if (cellFormat == DATE_CELLFORMAT) {
            sb.append("<TD class=\"axyusDate\">");
        } else if (level == 1) {
            sb.append("<TD class=\"axyusTitre\">");
        } else if (level == 2) {
            sb.append("<TD class=\"axyusNomsChamps\">");
        } else {
            sb.append("<TD>");
        }
        if (data != null) {
            sb.append(data);
        }
        sb.append("</TD>");
        return sb.toString();
    }

    public void writeNext(String[] nextLine, Integer maxInd) {
        if (nextLine == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<TR>");
        for (int i = 0; i <= maxInd; ++i) {
            String nextElement = nextLine[i];
            if (nextElement != null) {
                sb.append(nextElement);
                continue;
            }
            sb.append("<TD></TD>");
        }
        sb.append("</TR>\n");
        this.pw.write(sb.toString());
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    public void close() throws IOException {
        logger.debug((Object)("HtmlTableWriter<" + this.fileName + ">.close()"));
        StringBuffer sb = new StringBuffer();
        sb.append("</TABLE>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        this.pw.write(sb.toString());
        this.pw.flush();
        this.pw.close();
        this.rawWriter.close();
    }

    static {
        TEXT_CELLFORMAT = 0;
        INTEGER_CELLFORMAT = 1;
        FLOAT_CELLFORMAT = 2;
        DATE_CELLFORMAT = 3;
    }
}

