/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.txt2xml;

import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class AbstractTxt2Xml {
    private static final Logger logger = Logger.getLogger(AbstractTxt2Xml.class);
    private static final DecimalFormat df = new DecimalFormat("##0.0000");

    public String getAmount(String montant) {
        Double mt = 0.0;
        try {
            if (montant.trim().length() > 0) {
                mt = Double.parseDouble(montant);
            }
            return df.format(mt / 100.0);
        }
        catch (NumberFormatException ex) {
            logger.debug((Object)("Probl\u00e8me lors du formattage du montant (" + montant + ") : " + ex.getLocalizedMessage()));
            return montant;
        }
    }

    public String getDateLong(String date) {
        if (date.length() == 8) {
            String annee = date.substring(0, 4);
            String mois = date.substring(4, 6);
            String jour = date.substring(6, 8);
            return new StringBuffer(annee).append("-").append(mois).append("-").append(jour).toString();
        }
        logger.debug((Object)("Probl\u00e8me lors du formattage de la date (" + date + ") "));
        return date;
    }
}

