/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.utils.jdbc;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public interface PStmtBinder {
    public static final PStmtBinder nullPStmtBinder = new NullPStmtBinder();

    public void bind(PreparedStatement var1) throws SQLException;

    public String toLogableBindedString(String var1);

    public String toLogableParametersString();

    public static class NullPStmtBinder
    extends SimplePStmtBinder {
        private NullPStmtBinder() {
            super(null, null);
        }
    }

    public static class SimplePStmtBinder
    implements PStmtBinder {
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        private Object[] parameters;
        private int[] sqlTypes;

        public SimplePStmtBinder(Object[] parameters) {
            this(parameters, null);
        }

        public SimplePStmtBinder(Object[] parameters, int[] sqlTypes) {
            this.parameters = parameters;
            this.sqlTypes = sqlTypes;
        }

        public void bind(PreparedStatement pStmt) throws SQLException {
            for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
                Integer sqlType = this.getSQLType(pStmt, i);
                Object value = this.parameters[i];
                if (sqlType != null && sqlType != 0) {
                    pStmt.setObject(i + 1, value, sqlType);
                    continue;
                }
                pStmt.setObject(i + 1, value);
            }
        }

        public String toLogableBindedString(String sql) {
            for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
                String param = this.parameters[i] == null ? "null" : (this.parameters[i] instanceof String ? "'" + this.parameters[i].toString() + "'" : (this.parameters[i] instanceof Date ? "TO_DATE('" + dateFormat.format(this.parameters[i]) + "', 'DD/MM/YYYY')" : this.parameters[i].toString()));
                sql = SimplePStmtBinder.replaceFirstString(sql, "?", param);
            }
            return sql;
        }

        public String toLogableParametersString() {
            StringBuffer sb = new StringBuffer();
            if (this.parameters == null) {
                sb.append("no parameter");
            } else {
                for (int i = 0; i < this.parameters.length; ++i) {
                    if (i > 0) {
                        sb.append("\n");
                    }
                    sb.append("[");
                    sb.append(this.parameters[i] == null ? null : this.parameters[i]);
                    sb.append("]");
                }
            }
            return sb.toString();
        }

        private Integer getSQLType(PreparedStatement pStmt, int i) throws SQLException {
            if (this.sqlTypes != null && this.sqlTypes.length > i) {
                return new Integer(this.sqlTypes[i]);
            }
            ResultSetMetaData metaData = pStmt.getMetaData();
            return metaData != null ? new Integer(metaData.getColumnType(i + 1)) : null;
        }

        private static String replaceFirstString(String where, String what, String with) {
            int index = where.indexOf(what);
            if (index >= 0) {
                return where.substring(0, index) + with + where.substring(index + what.length());
            }
            return where;
        }
    }

    public static class SimplePStmtBinderBuilder {
        private List paramValues = new ArrayList();
        private List paramTypes = new ArrayList();

        public SimplePStmtBinder toPStmtBinder() {
            int[] paramTypesAsIntArray = new int[this.paramTypes.size()];
            for (int i = 0; i < this.paramTypes.size(); ++i) {
                paramTypesAsIntArray[i] = (Integer)this.paramTypes.get(i);
            }
            return new SimplePStmtBinder(this.paramValues.toArray(), paramTypesAsIntArray);
        }

        public SimplePStmtBinderBuilder add(int value) {
            this.paramValues.add(new Integer(value));
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(Integer value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(long value) {
            this.paramValues.add(new Long(value));
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(Long value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(float value) {
            this.paramValues.add(new Float(value));
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(Float value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(double value) {
            this.paramValues.add(new Double(value));
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(Double value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(String value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(12));
            return this;
        }

        public SimplePStmtBinderBuilder add(Date value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(91));
            return this;
        }

        public SimplePStmtBinderBuilder add(Timestamp value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(93));
            return this;
        }

        public SimplePStmtBinderBuilder add(BigDecimal value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(2));
            return this;
        }

        public SimplePStmtBinderBuilder add(boolean value) {
            this.paramValues.add(new Boolean(value));
            this.paramTypes.add(new Integer(16));
            return this;
        }

        public SimplePStmtBinderBuilder add(Boolean value) {
            this.paramValues.add(value);
            this.paramTypes.add(new Integer(16));
            return this;
        }

        public SimplePStmtBinderBuilder addAll(SimplePStmtBinder binder) {
            for (int i = 0; binder.parameters != null && i < binder.parameters.length; ++i) {
                this.paramValues.add(binder.parameters[i]);
                this.paramTypes.add(new Integer(binder.sqlTypes != null && i < binder.sqlTypes.length ? binder.sqlTypes[i] : 0));
            }
            return this;
        }
    }
}

