/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.impl.pool.impl;

import fr.gouv.finances.dgfip.xemelios.data.impl.pool.Pool;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.SQLRuntimeException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DsPool
implements Pool {
    private DataSource dataSource;

    public DsPool(String lookupName) {
        this(DsPool.getDSFromJNDI(lookupName));
    }

    public DsPool(DataSource dataSource) {
        this.dataSource = dataSource;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException sqle) {
            throw new SQLRuntimeException(sqle);
        }
        finally {
            try {
                this.releaseConnection(connection);
            }
            catch (SQLException sqle) {
                throw new SQLRuntimeException(sqle);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseConnection(Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean shutdown() throws SQLException {
        return false;
    }

    private static DataSource getDSFromJNDI(String jndiName) {
        try {
            InitialContext ctx = new InitialContext();
            return (DataSource)ctx.lookup(jndiName);
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }

    public int getNumActive() {
        return 0;
    }

    public int getNumIdle() {
        return 0;
    }
}

