/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.impl.pool;

import fr.gouv.finances.dgfip.xemelios.common.Scramble;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.ConnectionInfo;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.Pool;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.SQLRuntimeException;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.impl.DbcpPool;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.impl.DsPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PoolManager {
    public static final transient String PROP_JNDI_POOLNAME = "jndi.poolname";
    public static final transient String PROP_DATABASE_URL = "database.url";
    public static final transient String PROP_DRIVER_CLASS_NAME = "driver.class";
    public static final transient String PROP_USERNAME = "user";
    public static final transient String PROP_PASSWORD = "password";
    public static final transient String PROP_MAX_ACTIVE = "max.active";
    public static final transient String PROP_MAX_WAIT = "max.wait";
    public static final transient String PROP_VALIDATION_QUERY = "validation.query";
    private static Logger logger = Logger.getLogger(PoolManager.class);
    private static final Object locker1 = new Object();
    private static final Object locker2 = new Object();
    private static PoolManager instance = new PoolManager();
    private Pool pool;
    private boolean init = false;

    private PoolManager() {
    }

    public static PoolManager getInstance() {
        return instance;
    }

    private void checkInit() {
        if (!this.init) {
            throw new RuntimeException("Le singleton " + this.getClass().getName() + " doit \u00eatre initialis\u00e9 avant usage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties props) {
        if (this.init) {
            return;
        }
        Object object = locker1;
        synchronized (object) {
            Object object2 = locker2;
            synchronized (object2) {
                if (props.containsKey(PROP_JNDI_POOLNAME)) {
                    this.pool = new DsPool(props.getProperty(PROP_JNDI_POOLNAME));
                } else {
                    Properties properties = new Properties();
                    StringBuffer buffer = new StringBuffer();
                    Enumeration<Object> keys = props.keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement().toString();
                        String value = props.getProperty(key);
                        if (PROP_DATABASE_URL.equals(key)) {
                            properties.setProperty("url", value);
                            continue;
                        }
                        if (PROP_DRIVER_CLASS_NAME.equals(key)) {
                            properties.setProperty("driverClassName", value);
                            continue;
                        }
                        if (PROP_USERNAME.equals(key)) {
                            properties.setProperty("username", value);
                            continue;
                        }
                        if (PROP_PASSWORD.equals(key)) {
                            properties.setProperty(PROP_PASSWORD, Scramble.unScramblePassword(value));
                            continue;
                        }
                        if (PROP_MAX_ACTIVE.equals(key)) {
                            properties.setProperty("maxActive", value);
                            continue;
                        }
                        if (PROP_MAX_WAIT.equals(key)) {
                            properties.setProperty("maxWait", value);
                            continue;
                        }
                        if (PROP_VALIDATION_QUERY.equals(key)) {
                            properties.setProperty("validationQuery", value);
                            continue;
                        }
                        buffer.append(key).append("=").append(value).append(";");
                    }
                    if (properties.getProperty("maxActive") == null) {
                        properties.setProperty("maxActive", "8");
                    }
                    if (properties.getProperty("maxWait") == null) {
                        properties.setProperty("maxWait", "-1");
                    }
                    properties.setProperty("connectionProperties", buffer.toString());
                    properties.setProperty("defaultAutoCommit", "true");
                    logger.debug((Object)properties);
                    this.pool = new DbcpPool(properties);
                }
                if (this.pool != null) {
                    this.init = true;
                }
            }
        }
    }

    private void assertIsNull(Object o, Properties props) {
        if (o != null) {
            logger.error((Object)("previous value is not null: " + o));
            throw new RuntimeException("Previous value was not null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws SQLRuntimeException {
        Object object = locker1;
        synchronized (object) {
            Object object2 = locker2;
            synchronized (object2) {
                try {
                    if (this.pool != null && this.pool.shutdown()) {
                        this.pool = null;
                    }
                }
                catch (SQLException sqlEx) {
                    throw new SQLRuntimeException(sqlEx);
                }
            }
        }
    }

    public void logPoolInfo() throws SQLRuntimeException {
        this.checkInit();
        Connection connection = null;
        try {
            connection = this.pool.getConnection();
            logger.info((Object)ConnectionInfo.fromConnection(connection).toString());
        }
        catch (SQLException sqle) {
            throw new SQLRuntimeException(sqle);
        }
        finally {
            try {
                this.pool.releaseConnection(connection);
            }
            catch (SQLException sqle) {
                throw new SQLRuntimeException(sqle);
            }
        }
    }

    public Connection getConnection() throws SQLRuntimeException {
        this.checkInit();
        try {
            return this.pool.getConnection();
        }
        catch (SQLException sqle) {
            throw new SQLRuntimeException(sqle);
        }
    }

    public void releaseConnection(Connection connection) throws SQLRuntimeException {
        this.checkInit();
        try {
            this.pool.releaseConnection(connection);
        }
        catch (SQLException sqle) {
            logger.error((Object)"releaseConnection(Connection)", (Throwable)sqle);
        }
    }

    public Pool getPool() {
        return this.pool;
    }
}

