/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data;

import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.PersistenceConfigParser;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TPersistenceConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractDataImpl
implements DataImpl {
    private static final Logger logger = Logger.getLogger(AbstractDataImpl.class);
    private final Object locker = new Object();
    protected static Map<String, Class> persistenceModels = new HashMap<String, Class>();
    protected Map<String, TPersistenceConfig> cachedPersistence = new HashMap<String, TPersistenceConfig>();
    protected File documentConfigDirectory = null;

    public boolean importElement(DocumentModel dm, EtatModel currentEtat, String sourceFileName, String elementName, Document element, int overwriteMode) throws DataAccessException {
        return false;
    }

    public void setDocumentsConfigDirectory(File directory) {
        this.documentConfigDirectory = directory;
    }

    public void reset() {
        this.cachedPersistence.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPersistenceConfig getPersistenceConfig(DocumentModel dm, XemeliosUser user) throws DataConfigurationException {
        TPersistenceConfig pc = this.cachedPersistence.get(dm.getId());
        long start = System.currentTimeMillis();
        if (pc == null) {
            Object object = this.locker;
            synchronized (object) {
                logger.info((Object)("Chargement de la configuration " + dm.getTitre()));
                String fileName = dm.getPersistenceConfigFile();
                File configFile = new File(new File(dm.getBaseDirectory()), fileName);
                try {
                    if (fileName.toUpperCase().endsWith(".XML")) {
                        PersistenceConfigParser handler = new PersistenceConfigParser(dm.getBaseDirectory());
                        handler.parse(configFile);
                        pc = (TPersistenceConfig)handler.getMarshallable();
                        pc.setBaseDirectory(dm.getBaseDirectory());
                        this.cachedPersistence.put(dm.getId(), pc);
                    } else if (fileName.toUpperCase().endsWith(".EXML")) {
                        PersistenceConfigParser handler = new PersistenceConfigParser(dm.getBaseDirectory());
                        String parentDocId = dm.getExtendedDocId();
                        DocumentModel parentConfig = Loader.getDocumentsInfos(null).getDocumentById(parentDocId);
                        TPersistenceConfig parentPersistConfig = this.getPersistenceConfig(parentConfig, user);
                        handler.setInitialData(parentPersistConfig);
                        handler.parse(configFile);
                        pc = (TPersistenceConfig)handler.getMarshallable();
                        pc.setBaseDirectory(dm.getBaseDirectory());
                        this.cachedPersistence.put(dm.getId(), pc);
                    }
                }
                catch (ParserConfigurationException pcEx) {
                    throw new DataConfigurationException(pcEx);
                }
                catch (IOException ioEx) {
                    throw new DataConfigurationException(ioEx);
                }
                catch (SAXException saxEx) {
                    throw new DataConfigurationException(saxEx);
                }
            }
        }
        return pc;
    }

    static {
        persistenceModels.put("xemelios-sql", TPersistenceConfig.class);
    }
}

