/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.dgfip.xemelios.common.config.EnfantModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.dgfip.xemelios.common.config.EnvironmentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PluginModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SimpleElement;
import fr.gouv.finances.dgfip.xemelios.common.config.VariableModel;
import fr.gouv.finances.dgfip.xemelios.common.config.XPathModel;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementModel
implements NoeudModifiable,
EnvironmentDomain,
PropertyChangeListener {
    public static final transient String TAG = "element";
    public static final transient QName QN = new QName("element");
    private static final Logger logger = Logger.getLogger(ElementModel.class);
    private static final Object locker = new Object();
    private NoeudModifiable _NMParent = null;
    private ListeResultatModel listeResultat;
    private Vector<CritereModel> vCriteres;
    private Hashtable<String, CritereModel> hCriteres;
    private Vector<PluginModel> plugins;
    private HashMap<String, PluginModel> hPlugins;
    private String id;
    private String titre;
    private String balise;
    private String xslt;
    private XPathModel path;
    private EtatModel parent;
    private boolean browsable = false;
    private boolean searchable = true;
    private boolean display = true;
    private EnvironmentModel env;
    private int maxDisplay = 100;
    private boolean modeAnomaly = false;
    private Vector<CritereModel> availableCriteres;
    private SimpleElement simpleParent;
    private EnfantModel enfants;
    private QName qn;
    private ArrayList<PropertyChangeListener> listeners;
    private String configXPath = null;

    public ElementModel(QName tagName) {
        this.qn = tagName;
        this.vCriteres = new Vector();
        this.hCriteres = new Hashtable();
        this.plugins = new Vector();
        this.hPlugins = new HashMap();
        this.listeners = new ArrayList();
        this.listeners.add(this);
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (ListeResultatModel.QN.equals(tagName)) {
            this.listeResultat = (ListeResultatModel)child;
            this.listeResultat.setParentAsNoeudModifiable(this);
            this.listeResultat.setParent(this);
        } else if (CritereModel.QN.equals(tagName)) {
            CritereModel c = (CritereModel)child;
            if (this.hCriteres.containsKey(c.getId())) {
                CritereModel old = this.hCriteres.get(c.getId());
                this.vCriteres.remove(old);
                this.hCriteres.remove(old.getId());
            }
            c.setParentAsNoeudModifiable(this);
            this.vCriteres.add(c);
            this.hCriteres.put(c.getId(), c);
        } else if (DocumentsMapping.PATH.equals(tagName)) {
            this.path = (XPathModel)child;
            this.path.setParentAsNoeudModifiable(this);
        } else if (PluginModel.QN.equals(tagName)) {
            PluginModel pm = (PluginModel)child;
            if (this.hPlugins.containsKey(pm.getId())) {
                PluginModel old = this.hPlugins.get(pm.getId());
                this.plugins.remove(old);
                this.hPlugins.remove(old.getId());
            }
            pm.setParentAsNoeudModifiable(this);
            this.plugins.add(pm);
            this.hPlugins.put(pm.getId(), pm);
        } else if (EnvironmentModel.QN.equals(tagName)) {
            this.env = (EnvironmentModel)child;
            this.env.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.PARENT.equals(tagName)) {
            this.simpleParent = (SimpleElement)child;
            this.simpleParent.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.ENFANTS.equals(tagName)) {
            this.enfants = (EnfantModel)child;
            this.enfants.setParentAsNoeudModifiable(this);
        } else {
            throw new SAXException("unexpected child element : " + tagName);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        this.titre = attributes.getValue("titre") != null ? attributes.getValue("titre") : this.titre;
        this.balise = attributes.getValue("balise") != null ? attributes.getValue("balise") : this.balise;
        this.xslt = attributes.getValue("xslt-file") != null ? attributes.getValue("xslt-file") : this.xslt;
        try {
            if (attributes.getValue("max-display") != null) {
                this.maxDisplay = attributes.getIntValue("max-display");
            }
        }
        catch (Throwable t) {
            logger.error((Object)("invalid int value for max-display: " + attributes.getValue("max-display")));
        }
        if (attributes.getValue("browsable") != null) {
            this.browsable = attributes.getBooleanValue("browsable");
        }
        if (attributes.getValue("searchable") != null) {
            this.searchable = attributes.getBooleanValue("searchable");
        }
        if (attributes.getValue("display") != null) {
            this.display = attributes.getBooleanValue("display");
        }
        if ("anomally".equals(attributes.getValue("mode"))) {
            this.modeAnomaly = true;
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null) {
            throw new InvalidXmlDefinition("//element/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + ")");
        }
        if (this.balise == null || this.balise.length() == 0) {
            throw new InvalidXmlDefinition("//element/@balise is required (" + this.getConfigXPath() + ")");
        }
        if (this.titre == null || this.titre.length() == 0) {
            throw new InvalidXmlDefinition("//element/@titre is required (" + this.getConfigXPath() + ")");
        }
        this.path.validate();
        if (this.env != null) {
            this.env.validate();
        }
        if (this.listeResultat != null) {
            this.listeResultat.validate();
        }
        if (this.simpleParent != null) {
            this.simpleParent.validate();
        }
        if (this.enfants != null) {
            this.enfants.validate();
        }
        for (CritereModel cm : this.vCriteres) {
            cm.validate();
        }
    }

    public String getBalise() {
        return this.balise;
    }

    public String getId() {
        return this.id;
    }

    public String getIdValue() {
        return this.getId();
    }

    public ListeResultatModel getListeResultat() {
        return this.listeResultat;
    }

    public String getTitre() {
        return this.titre;
    }

    public Vector<CritereModel> getCriteres() {
        return this.vCriteres;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public int getMaxDisplay() {
        return this.maxDisplay;
    }

    public Vector<PluginModel> getPlugins() {
        return this.plugins;
    }

    public ElementModel clone() {
        ElementModel em = new ElementModel(QN);
        try {
            if (this.listeResultat != null) {
                em.addChild((XmlMarshallable)this.listeResultat.clone(), ListeResultatModel.QN);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().listeResultat", t);
        }
        for (CritereModel cm : this.vCriteres) {
            try {
                em.addChild((XmlMarshallable)cm.clone(), CritereModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().critere", t);
            }
        }
        for (PluginModel pm : this.plugins) {
            try {
                em.addChild((XmlMarshallable)pm.clone(), PluginModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().plugin", t);
            }
        }
        em.id = this.id;
        em.titre = this.titre;
        em.balise = this.balise;
        try {
            if (this.path != null) {
                em.addChild((XmlMarshallable)this.path, DocumentsMapping.PATH);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().path", t);
        }
        em.maxDisplay = this.maxDisplay;
        em.browsable = this.browsable;
        em.display = this.display;
        try {
            if (this.env != null) {
                em.addChild((XmlMarshallable)this.env.clone(), EnvironmentModel.QN);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().environment", t);
        }
        em.modeAnomaly = this.modeAnomaly;
        em.searchable = this.searchable;
        em.xslt = this.xslt;
        em._NMParent = this._NMParent;
        em.simpleParent = this.simpleParent != null ? this.simpleParent.clone() : null;
        try {
            if (this.enfants != null) {
                em.addChild((XmlMarshallable)this.enfants, DocumentsMapping.ENFANTS);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().enfants", t);
        }
        return em;
    }

    public String getXslt() {
        if (this.xslt == null) {
            return this.parent.getXslt();
        }
        return this.xslt;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isModeAnomaly() {
        return this.modeAnomaly;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        return null;
    }

    @Override
    public boolean hasEnvironment(int domain) {
        if (this.env == null) {
            return false;
        }
        Enumeration<VariableModel> enumer = this.env.getVariables(domain);
        if (enumer == null) {
            return false;
        }
        return enumer.hasMoreElements();
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return this.env.getVariables(domain);
    }

    @Override
    public int getChildCount(int domain) {
        return 0;
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        return null;
    }

    public String toString() {
        return this.titre;
    }

    public EtatModel getParent() {
        return this.parent;
    }

    public void setParent(EtatModel parent) {
        this.parent = parent;
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if ("@max-display".equals(sTmp)) {
            return new Integer(this.getMaxDisplay());
        }
        if ("@mode".equals(sTmp)) {
            return this.isModeAnomaly();
        }
        throw new DataConfigurationException(sTmp + " is not readable");
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if ("@max-display".equals(sTmp)) {
            int newValue = Integer.parseInt((String)value);
            if (newValue != this.maxDisplay) {
                int oldValue = this.maxDisplay;
                this.maxDisplay = newValue;
                this.firePropertyChange("max-display", oldValue, newValue);
            }
        } else if ("@mode".equals(sTmp)) {
            boolean newValue = (Boolean)value;
            if (newValue != this.modeAnomaly) {
                this.modeAnomaly = newValue;
                this.firePropertyChange("mode", !newValue, newValue);
            }
        } else {
            throw new DataConfigurationException(sTmp + " is not readable");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("mode".equals(evt.getPropertyName())) {
            this.availableCriteres = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<CritereModel> getAvailableCriteres() {
        if (this.availableCriteres == null) {
            Object object = locker;
            synchronized (object) {
                this.availableCriteres = new Vector();
                int targetMode = this.isModeAnomaly() ? 2 : 1;
                for (CritereModel cm : this.getCriteres()) {
                    if ((cm.getMode() & targetMode) <= 0 || !cm.isAffichable()) continue;
                    this.availableCriteres.add(cm);
                }
            }
        }
        return this.availableCriteres;
    }

    public Iterator<PropertyChangeListener> getPropertyListeners() {
        if (this.listeners.isEmpty()) {
            return null;
        }
        return this.listeners.iterator();
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("liste-resultat".equals(tagName)) {
            return this.listeResultat;
        }
        if ("critere".equals(tagName)) {
            return this.hCriteres.get(id);
        }
        if ("path".equals(tagName)) {
            return this.path;
        }
        if ("plugin".equals(tagName)) {
            return (NoeudModifiable)this.plugins;
        }
        if ("environment".equals(tagName)) {
            return this.env;
        }
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00ef\u00bf\u00bd jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("critere".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("plugin".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("environment".equals(childTagName)) {
            return new String[]{""};
        }
        return null;
    }

    public void resetCharData() {
    }

    public EnfantModel getEnfant() {
        return this.enfants;
    }

    public void setEnfant(EnfantModel enfant) {
        this.enfants = enfant;
    }

    public SimpleElement getSimpleParent() {
        return this.simpleParent;
    }

    public CritereModel getCritere(String critereId) {
        return this.hCriteres.get(critereId);
    }

    public Element createSmallDOM(Document doc) {
        Element ret = doc.createElementNS("http://projets.admisource.gouv.fr/xemelios/namespaces#config", "conf:element");
        ret.setAttribute("id", this.getId());
        ret.setAttribute("libelle", this.getTitre());
        return ret;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/element[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (ListeResultatModel.QN.equals(name)) {
            return this.listeResultat;
        }
        if (CritereModel.QN.equals(name)) {
            return (XmlMarshallable)this.hCriteres.get(atts.getValue("id"));
        }
        if (PluginModel.QN.equals(name)) {
            return (XmlMarshallable)this.hPlugins.get(atts.getValue("id"));
        }
        if (EnvironmentModel.QN.equals(name)) {
            return this.env;
        }
        if (DocumentsMapping.PARENT.equals(name)) {
            return this.simpleParent;
        }
        if (DocumentsMapping.ENFANTS.equals(name)) {
            return this.enfants;
        }
        return null;
    }

    public QName getQName() {
        return this.qn;
    }

    public boolean equals(ElementModel em) {
        if (em == null) {
            return false;
        }
        return this.getId().equals(em.getId());
    }

    public String getKey() {
        return this.getParent().getParent().getId() + "|" + this.getParent().getId() + "|" + this.getId();
    }

    public List<ElementModel> getSousElements() {
        Vector<ElementModel> ret = new Vector<ElementModel>();
        if (this.getEnfant() != null) {
            for (SimpleElement se : this.getEnfant().getEnfants().values()) {
                ret.add(this.getParent().getElementById(se.getElement()));
            }
        }
        return ret;
    }
}

