/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common;

import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileInfo {
    private Hashtable<EtatModel.Marker, Long> elementsCount = new Hashtable();
    private long globalCount = 0L;
    private String message;

    public void merge(FileInfo other) {
        if (other == null) {
            return;
        }
        Enumeration<EtatModel.Marker> enumer = other.elementsCount.keys();
        while (enumer.hasMoreElements()) {
            EtatModel.Marker marker = enumer.nextElement();
            Long otherCount = other.elementsCount.get(marker);
            Long thisCount = this.elementsCount.get(marker);
            if (thisCount != null) {
                otherCount = new Long(otherCount + thisCount);
            }
            this.elementsCount.put(marker, otherCount);
            other.elementsCount.remove(marker);
        }
        if (!other.elementsCount.isEmpty()) {
            this.elementsCount.putAll(other.elementsCount);
        }
        this.globalCount += other.getGlobalCount();
        this.message = this.message != null ? this.message.concat(other.getMessage()) : other.getMessage();
    }

    public void incElement(EtatModel.Marker marker) {
        Long ret = this.elementsCount.get(marker);
        if (ret == null) {
            ret = new Long(0L);
        }
        this.elementsCount.put(marker, new Long(ret + 1L));
        ++this.globalCount;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString(DocumentsModel dm) {
        StringBuffer ret = new StringBuffer();
        Hashtable<String, StringBuffer> docs = new Hashtable<String, StringBuffer>();
        Enumeration<EtatModel.Marker> enumer = this.elementsCount.keys();
        while (enumer.hasMoreElements()) {
            EtatModel.Marker marker = enumer.nextElement();
            StringBuffer doc = (StringBuffer)docs.get(marker.getDocId());
            if (doc == null) {
                doc = new StringBuffer();
                doc.append(dm.getDocumentById(marker.getDocId()).getTitre()).append("\n");
                docs.put(marker.getDocId(), doc);
            }
            doc.append("   ").append(dm.getDocumentById(marker.getDocId()).getEtatById(marker.getEtatId()).getTitre()).append("\t-> ").append(this.elementsCount.get(marker)).append(" \u00e9l\u00e9ments import\u00e9s\n");
        }
        Enumeration buffs = docs.elements();
        while (buffs.hasMoreElements()) {
            StringBuffer buff = (StringBuffer)buffs.nextElement();
            ret.append(buff);
        }
        if (ret.length() == 0) {
            ret.append("Aucune donn\u00e9e import\u00e9e.");
        }
        ret.append("\n");
        if (this.message != null) {
            ret.append(this.getMessage());
        }
        return ret.toString();
    }

    public long getGlobalCount() {
        return this.globalCount;
    }

    @Deprecated
    public String toString() {
        return super.toString();
    }
}

