/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.utils;

public class Luhn {
    private static char[] reverse(String s) {
        char[] ret = new char[s.length()];
        int index = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            ret[index++] = s.charAt(i);
        }
        return ret;
    }

    public static boolean testLuhnSiren(String s) {
        boolean isError = false;
        String sSansEsp = s.replaceAll(" ", "").replaceAll("-", "");
        if (sSansEsp.length() != 9 || !Luhn.testLuhnString(sSansEsp)) {
            isError = true;
        }
        return !isError;
    }

    public static boolean testLuhnSiret(String s) {
        boolean isError = false;
        String sSansEsp = s.replaceAll(" ", "").replaceAll("-", "");
        if (sSansEsp.length() != 14 || !Luhn.testLuhnString(sSansEsp)) {
            isError = true;
        }
        return !isError;
    }

    public static boolean testLuhnString(String s) {
        boolean isError = false;
        char[] ccNumArray = Luhn.reverse(s);
        int len = ccNumArray.length;
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            int num = ccNumArray[i] - 48;
            if (i == 0) {
                sum += num;
                continue;
            }
            if (i % 2 != 0) {
                if ((num *= 2) > 9) {
                    num -= 9;
                }
                sum += num;
                continue;
            }
            sum += num;
        }
        isError = sum % 10 != 0;
        return !isError;
    }
}

