<?xml version="1.0" encoding="UTF-8"?>
<!--
    * Copyright
    *   2010 axYus - www.axyus.com
    *   2010 c.Marchand - christophe.marchand@axyus.com
    *
    * This file is part of XEMELIOS.
    *
    * XEMELIOS is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * XEMELIOS is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with XEMELIOS; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
      xmlns:xs="http://www.w3.org/2001/XMLSchema"
      exclude-result-prefixes="xs"
      xmlns:n="dgfip:collectivite.spl"
      xmlns:added="http://projets.admisource.gouv.fr/xemelios/namespaces#added"
      version="2.0">
    
    <xsl:param name="archive"/>
    
    <xsl:template match="/n:Referentiel">
        <xsl:element name="Referentiel" namespace="dgfip:collectivite.spl">
            <xsl:copy-of select="added:Coll"/>
            <xsl:copy-of select="added:Budg"/>
            <xsl:copy-of select="n:Exercice"/>
            <xsl:element name="CollectivitesSPL" namespace="dgfip:collectivite.spl">
                <xsl:element name="Collectivite" namespace="dgfip:collectivite.spl">
                    <xsl:for-each select="n:CollectivitesSPL/n:Collectivite/@*">
                        <xsl:if test="not(name(.) eq 'archive')">
                            <xsl:copy-of select="."/>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:attribute name="archive" select="$archive"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
    

</xsl:stylesheet>
