/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.cg.linkResolver;

import fr.gouv.finances.dgfip.utils.NavigationContext;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.transform.CustomURIResolver;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.common.config.customLinks.CustomLinkParameters;
import fr.gouv.finances.dgfip.xemelios.common.config.customLinks.CustomLinkResolver;
import fr.gouv.finances.dgfip.xemelios.common.config.customLinks.UnresolvedException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class CGCustomLinkResolver
extends CustomLinkResolver {
    private static final Logger logger = Logger.getLogger(CGCustomLinkResolver.class);
    private Properties xslParameters = new Properties();

    public CGCustomLinkResolver() {
        logger.debug((Object)"instanciating");
    }

    public NavigationContext resolve(CustomLinkParameters parameters, Result result, NavigationContext ctx, XemeliosUser user) throws DataConfigurationException, UnresolvedException {
        logger.debug((Object)"in resolve(CustomLinkParameters,Result,NavigationContext,XemeliosUser)");
        if (parameters.getParameter("form") != null && parameters.getParameter("form").equals("page")) {
            this.treatGoto(parameters, ctx, user);
            this.commonTreatment(parameters, ctx, result, user);
        } else if (parameters.getParameter("navigation") != null && Boolean.parseBoolean(parameters.getParameter("navigation")) && parameters.getSrcDocId().equals("compteGestion")) {
            this.treatNavigation(parameters, ctx, user);
            this.commonTreatment(parameters, ctx, result, user);
        } else if (parameters.getSrcDocId().equals("compteGestion") && parameters.getSrcEtatId().equals("BalanceGenerale")) {
            this.treatBalanceGenerale(parameters, ctx);
            this.commonTreatment(parameters, ctx, result, user);
        } else if (parameters.getSrcDocId().equals("compteGestion") && parameters.getSrcEtatId().equals("Solde")) {
            this.treatGotoSolde(parameters, ctx, user);
            this.commonTreatment(parameters, ctx, result, user);
        } else if (parameters.getSrcDocId().equals("compteGestion") && parameters.getSrcEtatId().equals("FichesBudgetaires")) {
            this.treatFichesBudgetaires(parameters, ctx);
            this.commonTreatment(parameters, ctx, result, user);
        } else if (parameters.getSrcDocId().equals("compteGestion") && parameters.getSrcEtatId().equals("Accueil")) {
            this.treatAccueil(parameters, ctx, user);
            this.commonTreatment(parameters, ctx, result, user);
        }
        return ctx;
    }

    private void commonTreatment(CustomLinkParameters parameters, NavigationContext ctx, Result result, XemeliosUser user) throws UnresolvedException, DataConfigurationException {
        logger.debug((Object)"in commontTreatment(CustomLinkParameters,NavigationContext,Result,XemeliosUser)");
        try {
            ArrayList documents;
            DataImpl impl = DataLayerManager.getImplementation();
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById(ctx.getDocId());
            EtatModel em = dm.getEtatById(ctx.getEtatId());
            ElementModel element = em.getElementById(ctx.getElementId());
            File xslFile = null;
            xslFile = new File(new File(new File(System.getProperty("user.home")), "xemelios/documents-def-ovrrd"), element.getXslt());
            if (!xslFile.exists()) {
                xslFile = new File(em.getParent().getBaseDirectory(), element.getXslt());
            }
            FileInputStream fis = new FileInputStream(xslFile);
            String docId = null;
            if (ctx.getPath() == null) {
                documents = impl.getDocumentListFromSpecialKeys(element, ctx.getCollectivite(), ctx.getBudget(), ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), user);
                if (documents.size() == 0) {
                    throw new UnresolvedException("Le document est introuvable.");
                }
                if (documents.size() > 1 && !em.isMultiPage()) {
                    throw new UnresolvedException("Plusieurs documents r\u00e9pondant \u00e0 ces crit\u00e8res ont \u00e9t\u00e9 trouv\u00e9s.");
                }
                docId = (String)documents.get(0);
            } else {
                if (ctx.getElementId() == null) {
                    ctx.setElementId(element.getId());
                }
                if (ctx.getPath() != null && ctx.getPath().startsWith("[")) {
                    ctx.setPath(element.getPath().getFormattedPath() + ctx.getPath());
                }
                if ((documents = impl.getDocumentListFromXPath(element, ctx.getCollectivite(), ctx.getBudget(), ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), ctx.getPath(), user)).size() == 0 && parameters.getParameter("compte") != null) {
                    throw new UnresolvedException("Ce compte n'est associ\u00e9 a aucun(e) " + ctx.getEtatId() + ".");
                }
                if (documents.size() == 0 && parameters.getParameter("page") != null) {
                    throw new UnresolvedException("Cette page n'est associ\u00e9e a aucun(e) " + ctx.getEtatId() + ".");
                }
                if (documents.size() > 1) {
                    docId = (String)documents.get(0);
                } else if (documents.size() > 0) {
                    docId = (String)documents.get(0);
                } else {
                    throw new UnresolvedException("Ce compte n'est associ\u00e9 a aucun(e) " + ctx.getEtatId() + ".");
                }
            }
            Document doc = impl.getDocumentAsDom(em, new Pair(ctx.getCollectivite(), null), new Pair(ctx.getBudget(), null), docId, user);
            TransformerFactory tFactory = TransformerFactoryImpl.newInstance();
            tFactory.setURIResolver((URIResolver)new CustomURIResolver(tFactory.getURIResolver(), xslFile.getParentFile().toURI().toURL().toExternalForm()));
            Transformer t = tFactory.newTransformer(new StreamSource(xslFile));
            for (String key : parameters.getParameters().keySet()) {
                String paramValue;
                if (key.startsWith("xsl:param")) {
                    paramValue = parameters.getParameter(key);
                    int virg = paramValue.indexOf(44);
                    String pName = paramValue.substring(1, virg);
                    String pValue = paramValue.substring(virg + 1, paramValue.length() - 1);
                    t.setParameter(pName, pValue);
                    logger.debug((Object)("putting xsl param(" + pName + "," + pValue + ")"));
                    continue;
                }
                paramValue = parameters.getParameter(key);
                if (t.getParameter(key) != null) continue;
                t.setParameter(key, paramValue);
                logger.debug((Object)("putting other param(" + key + "," + paramValue + ")"));
            }
            for (Object o : this.getXslParameters().keySet()) {
                String key = (String)o;
                String paramValue = this.getXslParameters().getProperty(key);
                if (t.getParameter(key) != null) continue;
                t.setParameter(key, paramValue);
                logger.debug((Object)("putting other param(" + key + "," + paramValue + ")"));
            }
            t.setParameter("browser-destination", "internal");
            t.transform(new DOMSource(doc), result);
        }
        catch (UnresolvedException unEx) {
            throw unEx;
        }
        catch (Exception e) {
            logger.error((Object)"commontTreatment(CustomLinkParameters,NavigationContext,Result,XemeliosUser)", (Throwable)e);
            throw new DataConfigurationException((Throwable)e);
        }
    }

    private void treatBalanceGenerale(CustomLinkParameters parameters, NavigationContext ctx) {
        try {
            logger.debug((Object)"in treatBalanceGenerale(CustomLinkParameters parameters,NavigationContext ctx)");
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById(parameters.getSrcDocId());
            String baseDir = dm.getBaseDirectory();
            File f = new File(baseDir, dm.getParameters().getParameter("liens.balance").getValue());
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document LiensBalance = db.parse(f);
            String CodRD = parameters.getParameter("CodRD") != null ? parameters.getParameter("CodRD") : "";
            String numCompte = parameters.getParameter("numCompte");
            ctx.setDocId("compteGestion");
            if (parameters.getSrcCollectivite() != null) {
                ctx.setCollectivite(parameters.getSrcCollectivite());
            }
            if (parameters.getSrcBudget() != null) {
                ctx.setBudget(parameters.getSrcBudget());
            }
            if (parameters.getParameter("sp1") != null) {
                ctx.setSp1(parameters.getParameter("sp1"));
            }
            if (parameters.getParameter("sp2") != null) {
                ctx.setSp2(parameters.getParameter("sp2"));
            }
            if (parameters.getParameter("sp3") != null) {
                ctx.setSp3(parameters.getParameter("sp3"));
            }
            String budgetBA = parameters.getParameter("BudgetBA");
            String siretBA = parameters.getParameter("SiretBA");
            if (numCompte != null) {
                if (numCompte.startsWith("1")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]" + this.getPathBudgetAnnexe(budgetBA, siretBA));
                } else if (numCompte.startsWith("2")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]" + this.getPathBudgetAnnexe(budgetBA, siretBA));
                } else if ((numCompte.startsWith("4") || numCompte.startsWith("5")) && !numCompte.startsWith("48") && !numCompte.startsWith("49")) {
                    XPath xp = XPathFactory.newInstance().newXPath();
                    String compteGestion = parameters.getParameter("cg");
                    String typeLien = parameters.getParameter("type");
                    String etatSolde = xp.evaluate("/Editions/Comptes[@Edition='" + compteGestion + "']/Compte[@Numero='" + numCompte + "']/@Solde", LiensBalance.getDocumentElement());
                    String etatDebit = xp.evaluate("/Editions/Comptes[@Edition='" + compteGestion + "']/Compte[@Numero='" + numCompte + "']/@Debit", LiensBalance.getDocumentElement());
                    String etatCredit = xp.evaluate("/Editions/Comptes[@Edition='" + compteGestion + "']/Compte[@Numero='" + numCompte + "']/@Credit", LiensBalance.getDocumentElement());
                    if (etatSolde != null && !etatSolde.equals("") && typeLien.equals("solde")) {
                        String path = "";
                        if (etatSolde.equals("ERAR") || etatSolde.equals("ERAP")) {
                            path = etatSolde.equals("ERAR") ? path + "[n:EnteteSolde/@Type='RAR']" : path + "[n:EnteteSolde/@Type='RAP']";
                            etatSolde = "Solde";
                        }
                        ctx.setEtatId(etatSolde);
                        ctx.setElementId("Page" + etatSolde);
                        path = path + "[n:Entete" + etatSolde + "/@NumCompte=" + numCompte + "]";
                        if (!(CodRD == null || CodRD.equals("") || etatSolde.equals("DeveloppementSoldes") || etatSolde.equals("Solde") || etatSolde.equals("LivreAuxiliaire"))) {
                            path = path + "[n:Entete" + etatSolde + "/@CodRD=" + CodRD + "]";
                        }
                        ctx.setPath(path + this.getPathBudgetAnnexe(budgetBA, siretBA));
                    } else if (etatCredit != null && !etatCredit.equals("") && typeLien.equals("totaux") && CodRD != null && CodRD.equals("R")) {
                        String path = "";
                        if (etatCredit.equals("ERAR") || etatCredit.equals("ERAP")) {
                            path = etatCredit.equals("ERAR") ? path + "[n:EnteteSolde/@Type='RAR']" : path + "[n:EnteteSolde/@Type='RAP']";
                            etatCredit = "Solde";
                        }
                        ctx.setEtatId(etatCredit);
                        ctx.setElementId("Page" + etatCredit);
                        path = path + "[n:Entete" + etatCredit + "/@NumCompte=" + numCompte + "]";
                        if (!(CodRD == null || CodRD.equals("") || etatCredit.equals("DeveloppementSoldes") || etatCredit.equals("Solde") || etatCredit.equals("LivreAuxiliaire"))) {
                            path = path + "[n:Entete" + etatCredit + "/@CodRD=" + CodRD + "]";
                        }
                        ctx.setPath(path + this.getPathBudgetAnnexe(budgetBA, siretBA));
                    } else if (etatDebit != null && !etatDebit.equals("") && typeLien.equals("totaux") && CodRD != null && CodRD.equals("D")) {
                        String path = "";
                        if (etatDebit.equals("ERAR") || etatDebit.equals("ERAP")) {
                            path = etatDebit.equals("ERAR") ? path + "[n:EnteteSolde/@Type='RAR']" : path + "[n:EnteteSolde/@Type='RAP']";
                            etatDebit = "Solde";
                        }
                        ctx.setEtatId(etatDebit);
                        ctx.setElementId("Page" + etatDebit);
                        path = path + "[n:Entete" + etatDebit + "/@NumCompte=" + numCompte + "]";
                        if (!(CodRD == null || CodRD.equals("") || etatDebit.equals("DeveloppementSoldes") || etatDebit.equals("Solde") || etatDebit.equals("LivreAuxiliaire"))) {
                            path = path + "[n:Entete" + etatDebit + "/@CodRD=" + CodRD + "]";
                        }
                        ctx.setPath(path + this.getPathBudgetAnnexe(budgetBA, siretBA));
                    } else {
                        ctx.setEtatId("LivreAuxiliaire");
                        ctx.setElementId("PageLivreAuxiliaire");
                        ctx.setPath("[n:EnteteLivreAuxiliaire/@NumCompte=" + numCompte + "]" + this.getPathBudgetAnnexe(budgetBA, siretBA));
                    }
                } else if (numCompte.startsWith("48")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "R" : "D";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]" + this.getPathBudgetAnnexe(budgetBA, siretBA));
                } else if (numCompte.startsWith("49")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "R" : "D";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]" + this.getPathBudgetAnnexe(budgetBA, siretBA));
                } else if (numCompte.startsWith("6")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "R" : "D";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]" + this.getPathBudgetAnnexe(budgetBA, siretBA));
                } else if (numCompte.startsWith("7")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "D" : "R";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]" + this.getPathBudgetAnnexe(budgetBA, siretBA));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPathBudgetAnnexe(String budgetBA, String siretBA) {
        return (budgetBA != null && budgetBA.length() == 2 ? "[@added:BudgetBA=" + budgetBA + "]" : "") + (siretBA != null && siretBA.length() == 14 ? "[@added:SiretBA=" + siretBA + "]" : "");
    }

    private void treatFichesBudgetaires(CustomLinkParameters parameters, NavigationContext ctx) throws UnresolvedException {
        try {
            String codRD = parameters.getParameter("codRD");
            String exercice = parameters.getParameter("exercice");
            String mtEmis = parameters.getParameter("mtEmis");
            String mtAnn = parameters.getParameter("mtAnn");
            String mandatId = parameters.getParameter("mandatId");
            ctx.setDocId("PES_Aller");
            if (codRD.equals("D")) {
                ctx.setEtatId("PES_DepenseAller");
                ctx.setElementId("Piece");
            } else {
                ctx.setEtatId("PES_RecetteAller");
                ctx.setElementId("PieceRecette");
            }
            if (parameters.getSrcCollectivite() != null) {
                ctx.setCollectivite(parameters.getSrcCollectivite());
            }
            if (parameters.getSrcBudget() != null) {
                ctx.setBudget(parameters.getSrcBudget());
            }
            if (ctx.getSp1() != null) {
                ctx.setSp1(null);
            }
            String typeBordereau = "";
            if (mtEmis != null && mtEmis.length() > 0) {
                typeBordereau = "01";
            } else if (mtAnn != null && mtAnn.length() > 0) {
                typeBordereau = "02";
            }
            StringBuffer path = new StringBuffer();
            path.append("[../n:BlocBordereau/n:Exer/@V=").append(exercice).append("][../n:BlocBordereau/n:TypBord/@V=").append(typeBordereau).append("]");
            if ("D".equals(codRD)) {
                path.append("[n:BlocPiece/n:InfoPce/n:IdPce/@V=").append(mandatId).append("]");
            } else {
                path.append("[n:BlocPiece/n:IdPce/@V=").append(mandatId).append("]");
            }
            ctx.setPath(path.toString());
        }
        catch (Exception e) {
            logger.debug((Object)"Erreur", (Throwable)e);
            throw new UnresolvedException("treatFichesBudgetaires(CustomLinkParameters parameters,NavigationContext ctx)");
        }
    }

    private void treatGoto(CustomLinkParameters parameters, NavigationContext ctx, XemeliosUser user) throws UnresolvedException {
        try {
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById(parameters.getSrcDocId());
            EtatModel em = dm.getEtatById(parameters.getSrcEtatId());
            ElementModel elm = em.getElementById(parameters.getSrcElementId());
            DataImpl impl = DataLayerManager.getImplementation();
            Pair collectivite = new Pair(parameters.getParameter("srcCollectiviteCode"), parameters.getParameter("srcCollectiviteLibelle"));
            Pair budget = null;
            Vector budgets = impl.getBudgets(dm, collectivite, user);
            for (Pair budg : budgets) {
                if (!budg.key.equals(parameters.getParameter("srcBudgetCode"))) continue;
                budget = budg;
            }
            int numPage = parameters.getParameter("page") != null ? Integer.parseInt(parameters.getParameter("page")) : -1;
            int compte = parameters.getParameter("compte") != null ? Integer.parseInt(parameters.getParameter("compte")) : -1;
            ctx.setDocId(parameters.getSrcDocId());
            ctx.setEtatId(em.getBalise());
            ctx.setElementId(elm.getBalise());
            ctx.setCollectivite(collectivite.key);
            ctx.setBudget(budget.key);
            String budgetBA = parameters.getParameter("BudgetBA");
            String siretBA = parameters.getParameter("SiretBA");
            String pathSecondaire = "";
            Pair pairBA = new Pair(siretBA, budgetBA);
            if (parameters.getParameter("sp1") != null) {
                ctx.setSp1(parameters.getParameter("sp1"));
            }
            if (parameters.getParameter("sp2") != null) {
                ctx.setSp2(parameters.getParameter("sp2"));
            }
            if (parameters.getParameter("sp3") != null) {
                ctx.setSp3(parameters.getParameter("sp3"));
            }
            if (this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key) != null && this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key).length() > 0) {
                pathSecondaire = pathSecondaire + this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key);
            } else if (this.isEtatSpecial(elm.getBalise())) {
                pathSecondaire = pathSecondaire + "[@added:BudgetBA='']";
            }
            if (parameters.getParameter("pathplus") != null) {
                pathSecondaire = pathSecondaire + parameters.getParameter("pathplus");
            }
            if (numPage != -1) {
                logger.debug((Object)"in treatGoto(CustomLinkParameters parameters,NavigationContext ctx) : Type=Page");
                if (parameters.getParameter("path") != null) {
                    ctx.setPath(parameters.getParameter("path").replace("%page%", String.valueOf(numPage)));
                }
                if (siretBA != null && siretBA.length() > 0) {
                    ctx.setPath((ctx.getPath() == null ? "" : ctx.getPath()) + pathSecondaire);
                } else {
                    ArrayList docs = impl.getDocumentListFromSpecialKeys(elm, parameters.getParameter("srcCollectiviteCode"), parameters.getParameter("srcBudgetCode"), parameters.getParameter("sp1"), null, null, user);
                    Document doc = impl.getDocumentAsDom(em, collectivite, budget, (String)docs.get(0), user);
                    XPath xp = XPathFactory.newInstance().newXPath();
                    xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
                    String firstPage = (String)xp.evaluate("//n:LigneSommaire[@Code='" + em.getBalise() + "']/@FirstPage", doc.getDocumentElement(), XPathConstants.STRING);
                    String lastPage = (String)xp.evaluate("//n:LigneSommaire[@Code='" + em.getBalise() + "']/@LastPage", doc.getDocumentElement(), XPathConstants.STRING);
                    String firstPageCG = (String)xp.evaluate("//n:FirstPageCG/@V", doc.getDocumentElement(), XPathConstants.STRING);
                    String lastPageCG = (String)xp.evaluate("//n:LastPageCG/@V", doc.getDocumentElement(), XPathConstants.STRING);
                    if (lastPageCG != null && lastPageCG.length() > 0 && numPage > Integer.parseInt(lastPageCG)) {
                        throw new UnresolvedException("La page recherch\u00e9e est inexistante.\nLe Compte de Gestion finit \u00e0 la page " + lastPageCG + ".");
                    }
                    if (firstPageCG != null && firstPageCG.length() > 0 && numPage < Integer.parseInt(firstPageCG)) {
                        throw new UnresolvedException("La page recherch\u00e9e est inexistante.\nLe Compte de Gestion commence \u00e0 la page " + firstPageCG + ".");
                    }
                    if (firstPage != null && lastPage != null && firstPage.length() > 0 && lastPage.length() > 0 && (numPage < Integer.parseInt(firstPage) || numPage > Integer.parseInt(lastPage))) {
                        String etat = (String)xp.evaluate("//n:LigneSommaire[" + numPage + " >= @FirstPage and " + numPage + " <= @LastPage]/@Code", doc.getDocumentElement(), XPathConstants.STRING);
                        ctx.setEtatId(etat);
                        ctx.setElementId("Page" + etat);
                        if (parameters.getParameter("path") != null) {
                            ctx.setPath(parameters.getParameter("path").replace("%page%", String.valueOf(numPage)));
                        }
                    }
                }
            } else if (compte != -1) {
                logger.debug((Object)"in treatGoto(CustomLinkParameters parameters,NavigationContext ctx) : Type=Compte");
                if (parameters.getParameter("path") != null) {
                    String path = "";
                    if (parameters.getParameter("compte") != null) {
                        path = path + parameters.getParameter("path").replace("%compte%", String.valueOf(compte));
                    }
                    if (parameters.getParameter("codrd") != null) {
                        path = path + parameters.getParameter("path").replace("%codrd%", parameters.getParameter("codrd"));
                    }
                    ctx.setPath(path);
                }
                ctx.setPath((ctx.getPath() == null ? "" : ctx.getPath()) + pathSecondaire);
            }
        }
        catch (Exception e) {
            if (e instanceof UnresolvedException) {
                throw (UnresolvedException)((Object)e);
            }
            logger.debug((Object)"Erreur", (Throwable)e);
            throw new UnresolvedException("treatGotoPage(CustomLinkParameters parameters,NavigationContext ctx)");
        }
    }

    private void treatGotoSolde(CustomLinkParameters parameters, NavigationContext ctx, XemeliosUser user) throws UnresolvedException {
        try {
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById(parameters.getSrcDocId());
            EtatModel em = dm.getEtatById(parameters.getSrcEtatId());
            ElementModel elm = em.getElementById(parameters.getSrcElementId());
            DataImpl impl = DataLayerManager.getImplementation();
            XPath xp = XPathFactory.newInstance().newXPath();
            xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
            Pair collectivite = new Pair(parameters.getParameter("srcCollectiviteCode"), parameters.getParameter("srcCollectiviteLibelle"));
            Pair budget = null;
            Vector budgets = impl.getBudgets(dm, collectivite, user);
            for (Pair budg : budgets) {
                if (!budg.key.equals(parameters.getParameter("srcBudgetCode"))) continue;
                budget = budg;
            }
            int compte = parameters.getParameter("compte") != null ? Integer.parseInt(parameters.getParameter("compte")) : -1;
            String type = parameters.getParameter("type") != null ? parameters.getParameter("type") : "";
            String where = parameters.getParameter("where") != null ? parameters.getParameter("where") : "";
            ctx.setDocId(parameters.getSrcDocId());
            ctx.setEtatId(em.getBalise());
            ctx.setElementId(elm.getBalise());
            ctx.setCollectivite(collectivite.key);
            ctx.setBudget(budget.key);
            String budgetBA = parameters.getParameter("BudgetBA");
            String siretBA = parameters.getParameter("SiretBA");
            String pathSecondaire = "";
            Pair pairBA = new Pair(siretBA, budgetBA);
            if (parameters.getParameter("sp1") != null) {
                ctx.setSp1(parameters.getParameter("sp1"));
            }
            if (parameters.getParameter("sp2") != null) {
                ctx.setSp2(parameters.getParameter("sp2"));
            }
            if (parameters.getParameter("sp3") != null) {
                ctx.setSp3(parameters.getParameter("sp3"));
            }
            if (this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key) != null && this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key).length() > 0) {
                pathSecondaire = pathSecondaire + this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key);
            } else if (this.isEtatSpecial(em.getBalise())) {
                pathSecondaire = pathSecondaire + "[@added:BudgetBA='']";
            }
            if (parameters.getParameter("pathplus") != null) {
                pathSecondaire = pathSecondaire + parameters.getParameter("pathplus");
            }
            ArrayList docThisCompteThisType = new ArrayList();
            docThisCompteThisType = impl.getDocumentListFromXPath(elm, collectivite.key, budget.key, ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:EnteteSolde/@NumCompte=" + compte + "][n:EnteteSolde/@Type=" + type + "]" + pathSecondaire, user);
            String docIdName = "";
            if (where.equals("first")) {
                docIdName = (String)docThisCompteThisType.get(0);
            } else if (where.equals("last")) {
                docIdName = (String)docThisCompteThisType.get(docThisCompteThisType.size() - 1);
            }
            Document docDom = impl.getDocumentAsDom(em, collectivite, budget, docIdName, user);
            int numPage = Integer.parseInt((String)xp.evaluate("//n:Pied/@NumPage", docDom.getDocumentElement(), XPathConstants.STRING));
            ctx.setPath("[n:EnteteSolde/@Type=" + type + "][n:Pied/@NumPage=" + numPage + "]" + pathSecondaire);
        }
        catch (Exception e) {
            if (e instanceof UnresolvedException) {
                throw (UnresolvedException)((Object)e);
            }
            logger.debug((Object)"Erreur", (Throwable)e);
            throw new UnresolvedException("treatGotoPage(CustomLinkParameters parameters,NavigationContext ctx)");
        }
    }

    private void treatNavigation(CustomLinkParameters parameters, NavigationContext ctx, XemeliosUser user) throws UnresolvedException {
        try {
            logger.debug((Object)"in treatNavigation(CustomLinkParameters parameters,NavigationContext ctx)");
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById(parameters.getSrcDocId());
            EtatModel em = dm.getEtatById(parameters.getSrcEtatId());
            ElementModel elm = em.getElementById(parameters.getSrcElementId());
            DataImpl impl = DataLayerManager.getImplementation();
            ctx.setDocId(parameters.getSrcDocId());
            ctx.setEtatId(parameters.getSrcEtatId());
            ctx.setElementId(parameters.getSrcElementId());
            int numPage = Integer.parseInt(parameters.getParameter("numPage"));
            String sensNavigation = parameters.getParameter("sens");
            if (sensNavigation == null) {
                sensNavigation = "";
            }
            Pair collectivite = new Pair(parameters.getSrcCollectivite(), parameters.getParameter("srcCollectiviteLibelle"));
            Pair budget = null;
            Vector budgets = impl.getBudgets(dm, collectivite, user);
            for (Pair budg : budgets) {
                if (!budg.key.equals(parameters.getSrcBudget())) continue;
                budget = budg;
            }
            ctx.setCollectivite(collectivite.key);
            ctx.setBudget(budget.key);
            String budgetBA = parameters.getParameter("BudgetBA");
            String siretBA = parameters.getParameter("SiretBA");
            String pathSecondaire = "";
            Pair pairBA = new Pair(siretBA, budgetBA);
            if (parameters.getParameter("sp1") != null) {
                ctx.setSp1(parameters.getParameter("sp1"));
            }
            if (parameters.getParameter("sp2") != null) {
                ctx.setSp2(parameters.getParameter("sp2"));
            }
            if (parameters.getParameter("sp3") != null) {
                ctx.setSp3(parameters.getParameter("sp3"));
            }
            if (parameters.getParameter("path") != null) {
                ctx.setPath(parameters.getParameter("path").replace("%page%", String.valueOf(numPage)));
            }
            if (this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key) != null && this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key).length() > 0) {
                pathSecondaire = pathSecondaire + this.getPathBudgetAnnexe(pairBA.libelle, pairBA.key);
            } else if (this.isEtatSpecial(elm.getBalise())) {
                pathSecondaire = pathSecondaire + "[@added:BudgetBA='']";
            }
            if (parameters.getParameter("pathplus") != null) {
                pathSecondaire = pathSecondaire + parameters.getParameter("pathplus");
            }
            if (sensNavigation.equals("suivant")) {
                this.navigationSuivant(ctx, impl, dm, em, elm, collectivite, budget, numPage, pairBA, pathSecondaire, user);
            } else if (sensNavigation.equals("precedent")) {
                this.navigationPrecedent(ctx, impl, dm, em, elm, collectivite, budget, numPage, pairBA, pathSecondaire, user);
            } else if (sensNavigation.equals("premiere")) {
                this.navigationFirst(ctx, impl, dm, em, elm, collectivite, budget, numPage, pairBA, pathSecondaire, user);
            } else if (sensNavigation.equals("derniere")) {
                this.navigationLast(ctx, impl, dm, em, elm, collectivite, budget, numPage, pairBA, pathSecondaire, user);
            } else {
                ctx.setPath((ctx.getPath() == null ? "" : ctx.getPath()) + pathSecondaire);
            }
        }
        catch (Exception e) {
            if (e instanceof UnresolvedException) {
                throw (UnresolvedException)((Object)e);
            }
            logger.debug((Object)"Erreur", (Throwable)e);
            throw new UnresolvedException("treatNavigation(CustomLinkParameters parameters,NavigationContext ctx)");
        }
    }

    private void treatAccueil(CustomLinkParameters parameters, NavigationContext ctx, XemeliosUser user) throws UnresolvedException {
        try {
            logger.debug((Object)"in treatNavigation(CustomLinkParameters parameters,NavigationContext ctx)");
            String budgetBA = parameters.getParameter("BudgetBA");
            String siretBA = parameters.getParameter("SiretBA");
            ctx.setDocId((String)parameters.getParameters().get("docId"));
            ctx.setEtatId((String)parameters.getParameters().get("etatId"));
            ctx.setElementId((String)parameters.getParameters().get("elementId"));
            ctx.setBudget(parameters.getSrcBudget());
            ctx.setCollectivite(parameters.getSrcCollectivite());
            if (parameters.getParameter("sp1") != null) {
                ctx.setSp1(parameters.getParameter("sp1"));
            }
            if (parameters.getParameter("sp2") != null) {
                ctx.setSp2(parameters.getParameter("sp2"));
            }
            if (parameters.getParameter("sp3") != null) {
                ctx.setSp3(parameters.getParameter("sp3"));
            }
            if (parameters.getParameter("path") != null) {
                ctx.setPath(parameters.getParameter("path") + this.getPathBudgetAnnexe(budgetBA, siretBA));
            }
        }
        catch (Exception e) {
            if (e instanceof UnresolvedException) {
                throw (UnresolvedException)((Object)e);
            }
            logger.debug((Object)"Erreur", (Throwable)e);
            throw new UnresolvedException("treatNavigation(CustomLinkParameters parameters,NavigationContext ctx)");
        }
    }

    private void navigationSuivant(NavigationContext ctx, DataImpl impl, DocumentModel dm, EtatModel em, ElementModel elm, Pair collectivite, Pair budget, int numPage, Pair pairBA, String pathSecondaire, XemeliosUser user) throws Exception {
        logger.debug((Object)"in navigationSuivant(NavigationContext ctx, DataImpl impl, DocumentModel dm, EtatModel em, ElementModel elm, Pair collectivite, Pair budget, int numPage, Pair pairBA, XemeliosUser user)");
        XPath xp = XPathFactory.newInstance().newXPath();
        xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
        ArrayList docNextPage = new ArrayList();
        boolean nextPageNotFound = false;
        ArrayList docNextPageNotFound = new ArrayList();
        for (int deltaPageError = 1; deltaPageError < 6; ++deltaPageError) {
            int numPageToSwitch = numPage + deltaPageError;
            logger.debug((Object)("impl.getDocumentListFromXPath(" + elm + ", " + collectivite + ", " + budget + ", " + ctx.getSp1() + ", " + ctx.getSp2() + ", " + ctx.getSp3() + ", " + "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:Pied/@NumPage=" + (numPage + deltaPageError) + "]" + pathSecondaire + ", " + user + ")"));
            docNextPage = impl.getDocumentListFromXPath(elm, collectivite.key, budget.key, ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:Pied/@NumPage=" + (numPage + deltaPageError) + "]" + pathSecondaire, user);
            if (deltaPageError == 5) {
                docNextPageNotFound = impl.getDocumentListFromXPath(elm, collectivite.key, budget.key, ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:Pied/@NumPage=" + numPage + "]" + pathSecondaire, user);
            }
            if (docNextPage != null && docNextPage.size() > 0) {
                nextPageNotFound = true;
                ctx.setPath("[n:Pied/@NumPage=" + numPageToSwitch + "]" + pathSecondaire);
                break;
            }
            docNextPage.clear();
        }
        if (!nextPageNotFound) {
            Document docNextPageDom = impl.getDocumentAsDom(em, collectivite, budget, (String)docNextPageNotFound.get(0), user);
            logger.debug((Object)("docNextPageDom.getDocumentElement()=" + docNextPageDom.getDocumentElement()));
            String isLastPageEtat = (String)xp.evaluate("//n:" + elm.getBalise() + "[@added:isLastPage]", docNextPageDom.getDocumentElement(), XPathConstants.STRING);
            String nextEtat = null;
            String numNextPage = null;
            if (isLastPageEtat != null) {
                nextEtat = (String)xp.evaluate("//n:" + elm.getBalise() + "/@added:NextEtat", docNextPageDom.getDocumentElement(), XPathConstants.STRING);
                numNextPage = (String)xp.evaluate("//n:LigneSommaire[@Code='" + nextEtat + "']/@FirstPage", docNextPageDom.getDocumentElement(), XPathConstants.STRING);
            }
            if (nextEtat != null && nextEtat.length() > 0) {
                ctx.setEtatId(nextEtat);
                ctx.setElementId("Page" + nextEtat);
                ctx.setPath("[n:Pied/@NumPage=" + numNextPage + "]" + pathSecondaire);
            }
        }
    }

    private void navigationPrecedent(NavigationContext ctx, DataImpl impl, DocumentModel dm, EtatModel em, ElementModel elm, Pair collectivite, Pair budget, int numPage, Pair pairBA, String pathSecondaire, XemeliosUser user) throws Exception {
        logger.debug((Object)"in navigationPrecedent() !");
        XPath xp = XPathFactory.newInstance().newXPath();
        xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
        ArrayList docPreviousPage = new ArrayList();
        boolean previousPageNotFound = false;
        ArrayList docPreviousPageNotFound = new ArrayList();
        for (int deltaPageError = 1; deltaPageError < 6; ++deltaPageError) {
            docPreviousPage = impl.getDocumentListFromXPath(elm, collectivite.key, budget.key, ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:Pied/@NumPage=" + (numPage - deltaPageError) + "]" + pathSecondaire, user);
            if (deltaPageError == 5) {
                docPreviousPageNotFound = impl.getDocumentListFromXPath(elm, collectivite.key, budget.key, ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:Pied/@NumPage=" + numPage + "]" + pathSecondaire, user);
            }
            if (docPreviousPage != null && docPreviousPage.size() > 0) {
                previousPageNotFound = true;
                ctx.setPath("[n:Pied/@NumPage=" + (numPage - deltaPageError) + "]" + pathSecondaire);
                break;
            }
            docPreviousPage.clear();
        }
        if (!previousPageNotFound) {
            Document docPreviousPageDom = impl.getDocumentAsDom(em, collectivite, budget, (String)docPreviousPageNotFound.get(0), user);
            String previousEtat = (String)xp.evaluate("//n:" + elm.getBalise() + "[@added:PreviousEtat]/@added:PreviousEtat", docPreviousPageDom.getDocumentElement(), XPathConstants.STRING);
            String numPreviousPage = null;
            if (previousEtat != null) {
                numPreviousPage = (String)xp.evaluate("//n:LigneSommaire[@Code='" + previousEtat + "']/@LastPage", docPreviousPageDom.getDocumentElement(), XPathConstants.STRING);
            }
            logger.debug((Object)("previousEtat=" + previousEtat + " | numPreviousPage=" + numPreviousPage));
            if (previousEtat != null && previousEtat.length() > 0) {
                ctx.setEtatId(previousEtat);
                ctx.setElementId("Page" + previousEtat);
                ctx.setPath("[n:Pied/@NumPage=" + numPreviousPage + "]" + pathSecondaire);
            }
        }
    }

    private void navigationFirst(NavigationContext ctx, DataImpl impl, DocumentModel dm, EtatModel em, ElementModel elm, Pair collectivite, Pair budget, int numPage, Pair pairBA, String pathSecondaire, XemeliosUser user) throws Exception {
        logger.debug((Object)"in navigationFirst() !");
        XPath xp = XPathFactory.newInstance().newXPath();
        xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
        ArrayList docThisPage = impl.getDocumentListFromXPath(elm, collectivite.key, budget.key, ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:Pied/@NumPage=" + numPage + "]" + pathSecondaire, user);
        if (docThisPage != null && docThisPage.size() > 0) {
            Document docThisPageDom = impl.getDocumentAsDom(em, collectivite, budget, (String)docThisPage.get(0), user);
            if (!this.isEtatSpecial(em.getBalise())) {
                String firstEtat = (String)xp.evaluate("//n:FirstPageCG/@Etat", docThisPageDom.getDocumentElement(), XPathConstants.STRING);
                String numFirstPage = (String)xp.evaluate("//n:FirstPageCG/@V", docThisPageDom.getDocumentElement(), XPathConstants.STRING);
                if (firstEtat != null && firstEtat.length() > 0) {
                    ctx.setEtatId(firstEtat);
                    ctx.setElementId("Page" + firstEtat);
                    ctx.setPath("[n:Pied/@NumPage=" + numFirstPage + "]" + pathSecondaire);
                }
            } else {
                ctx.setPath("[n:Pied/@NumPage=1]" + pathSecondaire);
            }
        }
    }

    private void navigationLast(NavigationContext ctx, DataImpl impl, DocumentModel dm, EtatModel em, ElementModel elm, Pair collectivite, Pair budget, int numPage, Pair pairBA, String pathSecondaire, XemeliosUser user) throws Exception {
        logger.debug((Object)"in navigationLast() !");
        XPath xp = XPathFactory.newInstance().newXPath();
        xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
        ArrayList docThisPage = impl.getDocumentListFromXPath(elm, collectivite.key, budget.key, ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), "/n:" + dm.getBalise() + "/n:" + em.getBalise() + "/n:" + elm.getBalise() + "[n:Pied/@NumPage=" + numPage + "]" + pathSecondaire, user);
        if (docThisPage != null && docThisPage.size() > 0) {
            Document docThisPageDom = impl.getDocumentAsDom(em, collectivite, budget, (String)docThisPage.get(0), user);
            if (!this.isEtatSpecial(em.getBalise())) {
                String lastEtat = (String)xp.evaluate("//n:LastPageCG/@Etat", docThisPageDom.getDocumentElement(), XPathConstants.STRING);
                String numLastPage = (String)xp.evaluate("//n:LastPageCG/@V", docThisPageDom.getDocumentElement(), XPathConstants.STRING);
                if (lastEtat != null && lastEtat.length() > 0) {
                    ctx.setEtatId(lastEtat);
                    ctx.setElementId("Page" + lastEtat);
                    ctx.setPath("[n:Pied/@NumPage=" + numLastPage + "]" + pathSecondaire);
                }
            } else {
                String etat = em.getBalise();
                String codeEdition = (String)xp.evaluate("//n:Page" + etat + "/@CodeEdition", docThisPageDom.getDocumentElement(), XPathConstants.STRING);
                if (etat.equalsIgnoreCase("Solde")) {
                    etat = "Solde-" + codeEdition;
                }
                String numLastPage = (String)xp.evaluate("//n:LigneSommairePlus[@Code='" + etat + "']/@LastPage", docThisPageDom.getDocumentElement(), XPathConstants.STRING);
                logger.debug((Object)("lastpage=" + numLastPage + " ** codeEdition=" + etat));
                ctx.setPath("[n:Pied/@NumPage=" + numLastPage + "]" + pathSecondaire);
            }
        }
    }

    private boolean isEtatSpecial(String balise) {
        return balise.equals("Solde") || balise.equals("DeveloppementSoldes") || balise.equals("FichesBudgetaires") || balise.equals("LivreAuxiliaire");
    }

    public Properties getXslParameters() {
        return this.xslParameters;
    }

    public void setXslParameters(Properties additionalsParameters) {
        this.xslParameters = additionalsParameters;
    }

    private void debug(Document doc) {
        try {
            Transformer t = TransformerFactoryImpl.newInstance().newTransformer();
            t.transform(new DOMSource(doc), new StreamResult(System.out));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

